/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.NetUtils;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServiceController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.is.CachedObject;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster<T extends GeoServiceDescriptor, E extends GeoServiceController<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCluster.class);
    private long objectsTTL;
    private ConcurrentHashMap<String, CachedObject<ArrayList<E>>> scopedCache;
    private ISModule retriever;
    private String cacheName;

    public synchronized ArrayList<E> getActualCluster() throws ConfigurationNotFoundException {
        String key = ScopeUtils.getCurrentScope();
        log.info("Getting object from cache{} , key is {} ", (Object)this.cacheName, (Object)key);
        if (!this.scopedCache.containsKey(key) || !((CachedObject)this.scopedCache.get(key)).isValid(this.objectsTTL)) {
            this.scopedCache.put(key, new CachedObject((Object)this.getLiveControllerCollection()));
        }
        return (ArrayList)((CachedObject)this.scopedCache.get(key)).getTheObject();
    }

    protected ArrayList<E> getLiveControllerCollection() throws ConfigurationNotFoundException {
        ArrayList<GeoServiceController> toReturn = new ArrayList<GeoServiceController>();
        for (ServiceEndpoint endpoint : this.retriever.getISInformation()) {
            try {
                toReturn.add(this.translate(endpoint));
            }
            catch (Throwable t) {
                log.warn("Unable to handle ServiceEndpoint [name {} , ID {}]", new Object[]{endpoint.profile().name(), endpoint.id(), t});
            }
        }
        Comparator comp = this.getComparator();
        if (comp != null) {
            Collections.sort(toReturn, this.getComparator());
        }
        return toReturn;
    }

    protected abstract E translate(ServiceEndpoint var1) throws InvalidServiceEndpointException;

    public void invalidate() {
        String key = ScopeUtils.getCurrentScope();
        log.info("Invalidating cache {} under scope {} ", (Object)this.cacheName, (Object)key);
        if (this.scopedCache.containsKey(key)) {
            ((CachedObject)this.scopedCache.get(key)).invalidate();
        }
    }

    public void invalidateAll() {
        for (CachedObject obj : this.scopedCache.values()) {
            obj.invalidate();
        }
    }

    public E getDefaultController() throws ConfigurationNotFoundException {
        return (E)((GeoServiceController)this.getActualCluster().get(0));
    }

    protected abstract Comparator<E> getComparator();

    public E getControllerByHostName(String hostname) throws ConfigurationNotFoundException {
        ArrayList controllerCluster = this.getLiveControllerCollection();
        log.debug("Looking for {} inside cluster [size = {}]", (Object)hostname, (Object)controllerCluster.size());
        for (GeoServiceController toCheck : controllerCluster) {
            String toCheckHostname = NetUtils.getHostByURL((String)toCheck.getDescriptor().getBaseEndpoint());
            try {
                if (!NetUtils.isSameHost((String)toCheckHostname, (String)hostname)) continue;
                return (E)toCheck;
            }
            catch (UnknownHostException e) {
                log.warn("Unable to check equality between {} and {} hosts.", new Object[]{toCheckHostname, hostname, e});
            }
        }
        return null;
    }

    public AbstractCluster(long objectsTTL, ISModule retriever, String cacheName) {
        this.objectsTTL = objectsTTL;
        this.retriever = retriever;
        this.cacheName = cacheName;
        this.scopedCache = new ConcurrentHashMap();
    }
}

