/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.util.Collections;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.is.AbstractISModule;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.service.GeoServerDescriptor;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.gcube.spatial.data.sdi.model.services.GeoServerDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerClusterRetriever
extends AbstractISModule {
    private static final Logger log = LoggerFactory.getLogger(GeoServerClusterRetriever.class);

    private static final GeoServerDescriptor translate(AbstractGeoServerDescriptor desc) {
        Version version = new Version(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
        String baseEndpoint = desc.getUrl();
        List<Credentials> accessibleCredentials = Collections.singletonList(new Credentials(desc.getUser(), desc.getPassword(), AccessType.ADMIN));
        String confidentialWorkspace = null;
        String contextVisibilityWorkspace = null;
        String sharedWorkspace = null;
        String publicWorkspace = null;
        return new GeoServerDescriptor(version, baseEndpoint, accessibleCredentials, confidentialWorkspace, contextVisibilityWorkspace, sharedWorkspace, publicWorkspace);
    }

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.getProperty((String)"gs.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.getProperty((String)"gs.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "GeoServer";
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.getProperty((String)"gs.se.endpointName");
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.getProperty((String)"gs.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.getProperty((String)"gs.se.platform");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        return Collections.EMPTY_LIST;
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.GEOSERVER) || !(definition instanceof GeoServerDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.GEOSERVER + "]. Definition was " + definition);
        }
    }
}

