/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.swagger.annotations.Api;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoServerDescriptor;
import org.gcube.spatial.data.sdi.model.services.GeoServerDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="GeoServer")
@Api(value="GeoServer")
@ManagedBy(value=SDIServiceManager.class)
public class GeoServer {
    private static final Logger log = LoggerFactory.getLogger(GeoServer.class);
    private static final String HOST_PATH_PARAM = "host";
    @Inject
    private SDIManager sdi;

    @GET
    @Path(value="configuration/{host}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public GeoServerDescriptor getInstanceConfiguration(@PathParam(value="host") String host) {
        try {
            log.trace("Serving credentials for host {} ", (Object)host);
            host = GeoServer.getHost((String)host);
            List geoservers = this.sdi.getGeoServerManager().getAvailableInstances();
            log.trace("Got {} geoservers in current scope ", (Object)geoservers.size());
            for (GeoServerDescriptor config : geoservers) {
                String configHost = GeoServer.getHost((String)config.getBaseEndpoint());
                if (!configHost.equals(host)) continue;
                return config;
            }
            throw new WebApplicationException("Host " + host + " not found in context");
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @GET
    @Path(value="credentials/{host}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Credentials getInstanceCredentials(@PathParam(value="host") String host) {
        try {
            log.trace("Serving credentials for host {} ", (Object)host);
            host = GeoServer.getHost((String)host);
            return (Credentials)((GeoServerDescriptor)this.sdi.getGeoServerManager().getDescriptorByHostname(host)).getAccessibleCredentials().get(0);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/xml"})
    public String register(GeoServerDefinition toRegister) {
        try {
            return this.sdi.registerService((ServiceDefinition)toRegister);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @POST
    @Path(value="import/{host}")
    @Produces(value={"application/xml"})
    public String importFromScope(@QueryParam(value="sourceToken") String sourceToken, @PathParam(value="host") String host) {
        try {
            return this.sdi.importService(sourceToken, host, ServiceDefinition.Type.GEOSERVER);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    private static final String getHost(String endpoint) throws MalformedURLException {
        log.debug("Get host from endpoint {} ", (Object)endpoint);
        if (endpoint.startsWith("http")) {
            log.debug("Endpoint seems url..");
            return new URL(endpoint).getHost();
        }
        return endpoint;
    }
}

