/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.impl.AbstractManager;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.is.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;

@Singleton
public class GeoNetworkManagerImpl
extends AbstractManager<GeoNetworkDescriptor, GeoNetworkServiceDefinition, GeoNetworkController>
implements GeoNetworkManager {
    private GeoNetworkRetriever retriever = new GeoNetworkRetriever();
    private GeoNetworkCluster cluster = new GeoNetworkCluster(LocalConfiguration.getTTL((String)"gn.cache.TTL").longValue(), (ISModule)this.retriever, "GeoNEtwork - cache");

    protected AbstractCluster<GeoNetworkDescriptor, GeoNetworkController> getCluster() {
        return this.cluster;
    }

    protected ISModule getRetriever() {
        return this.retriever;
    }

    public List<GeoNetworkDescriptor> getSuggestedInstances() throws ConfigurationNotFoundException {
        return Collections.singletonList(((GeoNetworkController)this.getCluster().getDefaultController()).getDescriptor());
    }
}

