/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.proxies;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateCollection;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.gcube.spatial.data.sdi.utils.ResponseUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class DefaultMetadata
implements Metadata {
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;

    public DefaultMetadata(ProxyDelegate<GXWebTargetAdapterRequest> config) {
        this.delegate = config;
    }

    public TemplateCollection getAvailableTemplates() {
        Call<GXWebTargetAdapterRequest, Set<TemplateDescriptor>> call = new Call<GXWebTargetAdapterRequest, Set<TemplateDescriptor>>(){

            public Set<TemplateDescriptor> call(GXWebTargetAdapterRequest templates) throws Exception {
                GenericType<Set<TemplateDescriptor>> generic = new GenericType<Set<TemplateDescriptor>>(){};
                return (Set)ResponseUtils.check(templates.path("list").get()).readEntity((GenericType)generic);
            }
        };
        try {
            return new TemplateCollection(new HashSet((Collection)this.delegate.make((Call)call)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataReport pushMetadata(File toPublish) {
        return this.pushMetadata(toPublish, new MetadataPublishOptions());
    }

    public MetadataReport pushMetadata(final File toPublish, final MetadataPublishOptions options) {
        Call<GXWebTargetAdapterRequest, MetadataReport> applyTemplatesCall = null;
        Call<GXWebTargetAdapterRequest, MetadataReport> publishCall = null;
        try {
            Call<GXWebTargetAdapterRequest, String> uploadCall = new Call<GXWebTargetAdapterRequest, String>(){

                public String call(GXWebTargetAdapterRequest endpoint) throws Exception {
                    endpoint.register(MultiPartFeature.class);
                    FormDataMultiPart multi = new FormDataMultiPart();
                    FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("theMeta", toPublish, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    multi.bodyPart((BodyPart)fileDataBodyPart);
                    return ResponseUtils.check(endpoint.post(Entity.entity((Object)multi, (MediaType)multi.getMediaType())), String.class);
                }
            };
            final String id = (String)this.delegate.make((Call)uploadCall);
            applyTemplatesCall = new Call<GXWebTargetAdapterRequest, MetadataReport>(){

                public MetadataReport call(GXWebTargetAdapterRequest endpoint) throws Exception {
                    return ResponseUtils.check(endpoint.path(id).put(Entity.entity(new HashSet(options.getTemplateInvocations()), (String)"application/json")), MetadataReport.class);
                }
            };
            publishCall = new Call<GXWebTargetAdapterRequest, MetadataReport>(){

                public MetadataReport call(GXWebTargetAdapterRequest endpoint) throws Exception {
                    WeakHashMap<String, String> queryParams = new WeakHashMap<String, String>();
                    queryParams.put("validate", options.isValidate() + "");
                    queryParams.put("public", options.isMakePublic() + "");
                    queryParams.put("stylesheet", options.getGeonetworkStyleSheet());
                    return ResponseUtils.check(endpoint.path("publish").path(id).path(options.getGeonetworkCategory()).get(), MetadataReport.class);
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to upload file.", t);
        }
        MetadataReport templateReport = null;
        try {
            if (!options.getTemplateInvocations().isEmpty()) {
                templateReport = (MetadataReport)this.delegate.make((Call)applyTemplatesCall);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to apply templates", t);
        }
        try {
            MetadataReport publishReport = (MetadataReport)this.delegate.make((Call)publishCall);
            if (templateReport != null) {
                publishReport.setAppliedTemplates(templateReport.getAppliedTemplates());
            }
            return publishReport;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to publish metadata. ", t);
        }
    }
}

