/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.proxies;

import java.util.List;
import javax.ws.rs.core.MediaType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.spatia.data.model.profiles.ApplicationProfile;
import org.gcube.spatial.data.clients.SDIClientManager;
import org.gcube.spatial.data.clients.SDIGenericPlugin;
import org.gcube.spatial.data.sdi.interfaces.SDIManagement;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.gcube.spatial.data.sdi.utils.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSDIManagement
implements SDIManagement {
    private static final Logger log = LoggerFactory.getLogger(DefaultSDIManagement.class);
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;
    private SDIClientManager clientManager = null;

    public DefaultSDIManagement(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        this.delegate = delegate;
        this.clientManager = new SDIClientManager();
        log.debug("Available clients are ");
        this.clientManager.list().forEach(c -> log.debug("{}", c));
    }

    public ScopeConfiguration getConfiguration() throws RemoteException {
        Call<GXWebTargetAdapterRequest, ScopeConfiguration> call = new Call<GXWebTargetAdapterRequest, ScopeConfiguration>(){

            public ScopeConfiguration call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return ResponseUtils.check(endpoint.get(), ScopeConfiguration.class);
            }
        };
        try {
            return (ScopeConfiguration)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public HealthReport getReport() throws RemoteException {
        Call<GXWebTargetAdapterRequest, HealthReport> call = new Call<GXWebTargetAdapterRequest, HealthReport>(){

            public HealthReport call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return ResponseUtils.check(endpoint.setAcceptedResponseType(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).path("status").get(), HealthReport.class);
            }
        };
        try {
            return (HealthReport)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public ApplicationProfile getProfile(final String serviceClass, final String serviceName) throws RemoteException {
        Call<GXWebTargetAdapterRequest, ApplicationProfile> call = new Call<GXWebTargetAdapterRequest, ApplicationProfile>(){

            public ApplicationProfile call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return ResponseUtils.check(endpoint.path("profile").path(serviceClass).path(serviceName).get(), ApplicationProfile.class);
            }
        };
        try {
            return (ApplicationProfile)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public SDIGenericPlugin getClientByEngineId(String engineId) throws Exception {
        List desc = this.getConfiguration().getByEngine(engineId);
        if (desc == null || desc.isEmpty()) {
            throw new Exception("No " + engineId + " available in current context. Check ScopeConfiguration object.");
        }
        for (GeoServiceDescriptor d : desc) {
            SDIGenericPlugin c = this.clientManager.get(d);
            if (c == null) continue;
            return c;
        }
        throw new RuntimeException("No implementation available for " + engineId);
    }
}

