package org.gcube.spatial.data.sdi.proxies;

import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.util.Set;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.ServiceConstants;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.SetWrapper;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;

public class DefaultMetadata implements Metadata{

	private final ProxyDelegate<WebTarget> delegate;

	
	public DefaultMetadata(ProxyDelegate<WebTarget> config){
		this.delegate = config;
	}
	
	@Override
	public Set<TemplateDescriptor> getAvailableTemplates() {
		Call<WebTarget, Set<TemplateDescriptor>> call = new Call<WebTarget, Set<TemplateDescriptor>>() {
			@Override
			public Set<TemplateDescriptor> call(WebTarget templates) throws Exception {
				return templates.path(ServiceConstants.Metadata.LIST_METHOD).request(MediaType.APPLICATION_JSON).get(SetWrapper.class).getSet();				
			}
		};
		try {
			return delegate.make(call);			
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public MetadataReport pushMetadata(File toPublish) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MetadataReport pushMetadata(File toPublish, MetadataPublishOptions options) {
		// TODO Auto-generated method stub
		return null;
	}
	
}
