/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.services;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.NonNull;
import org.gcube.spatial.data.sdi.model.ParameterType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ServiceDefinition {
    @XmlElement(name="hostname")
    @NonNull
    private String hostname;
    @XmlElement(name="majorVersion")
    @NonNull
    private Short majorVersion;
    @XmlElement(name="minorVersion")
    @NonNull
    private Short minorVersion;
    @XmlElement(name="releaseVersion")
    private Short releaseVersion;
    @XmlElement(name="type")
    @NonNull
    private Type type;
    @XmlElement(name="adminPassword")
    @NonNull
    private String adminPassword;
    @XmlElement(name="properties")
    private ArrayList<ParameterType> properties;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="name")
    @NonNull
    private String name;

    public String toString() {
        return "ServiceDefinition [hostname=" + this.hostname + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", releaseVersion=" + this.releaseVersion + ", type=" + (Object)((Object)this.type) + ", properties=" + this.properties + ", description=" + this.description + ", name=" + this.name + "]";
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(new ParameterType(name, value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminPassword == null ? 0 : this.adminPassword.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        if (this.properties != null && !this.properties.isEmpty()) {
            for (ParameterType param : this.properties) {
                result = 31 * result + param.hashCode();
            }
        }
        result = 31 * result + (this.releaseVersion == null ? 0 : this.releaseVersion.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDefinition other = (ServiceDefinition)obj;
        if (this.adminPassword == null ? other.adminPassword != null : !this.adminPassword.equals(other.adminPassword)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.majorVersion == null ? other.majorVersion != null : !this.majorVersion.equals(other.majorVersion)) {
            return false;
        }
        if (this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (other.properties != null && !other.properties.isEmpty()) {
                return false;
            }
        } else {
            if (this.properties.size() != other.properties.size()) {
                return false;
            }
            if (!other.properties.containsAll(this.properties)) {
                return false;
            }
        }
        if (this.releaseVersion == null ? other.releaseVersion != null : !this.releaseVersion.equals(other.releaseVersion)) {
            return false;
        }
        return this.type == other.type;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    @NonNull
    public Short getMajorVersion() {
        return this.majorVersion;
    }

    @NonNull
    public Short getMinorVersion() {
        return this.minorVersion;
    }

    public Short getReleaseVersion() {
        return this.releaseVersion;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public String getAdminPassword() {
        return this.adminPassword;
    }

    public ArrayList<ParameterType> getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setHostname(@NonNull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname");
        }
        this.hostname = hostname;
    }

    public void setMajorVersion(@NonNull Short majorVersion) {
        if (majorVersion == null) {
            throw new NullPointerException("majorVersion");
        }
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(@NonNull Short minorVersion) {
        if (minorVersion == null) {
            throw new NullPointerException("minorVersion");
        }
        this.minorVersion = minorVersion;
    }

    public void setReleaseVersion(Short releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public void setType(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
    }

    public void setAdminPassword(@NonNull String adminPassword) {
        if (adminPassword == null) {
            throw new NullPointerException("adminPassword");
        }
        this.adminPassword = adminPassword;
    }

    public void setProperties(ArrayList<ParameterType> properties) {
        this.properties = properties;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public ServiceDefinition() {
    }

    @ConstructorProperties(value={"hostname", "majorVersion", "minorVersion", "releaseVersion", "type", "adminPassword", "properties", "description", "name"})
    public ServiceDefinition(@NonNull String hostname, @NonNull Short majorVersion, @NonNull Short minorVersion, Short releaseVersion, @NonNull Type type, @NonNull String adminPassword, ArrayList<ParameterType> properties, String description, @NonNull String name) {
        if (hostname == null) {
            throw new NullPointerException("hostname");
        }
        if (majorVersion == null) {
            throw new NullPointerException("majorVersion");
        }
        if (minorVersion == null) {
            throw new NullPointerException("minorVersion");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (adminPassword == null) {
            throw new NullPointerException("adminPassword");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.hostname = hostname;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.releaseVersion = releaseVersion;
        this.type = type;
        this.adminPassword = adminPassword;
        this.properties = properties;
        this.description = description;
        this.name = name;
    }

    @ConstructorProperties(value={"hostname", "majorVersion", "minorVersion", "type", "adminPassword", "name"})
    public ServiceDefinition(@NonNull String hostname, @NonNull Short majorVersion, @NonNull Short minorVersion, @NonNull Type type, @NonNull String adminPassword, @NonNull String name) {
        if (hostname == null) {
            throw new NullPointerException("hostname");
        }
        if (majorVersion == null) {
            throw new NullPointerException("majorVersion");
        }
        if (minorVersion == null) {
            throw new NullPointerException("minorVersion");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (adminPassword == null) {
            throw new NullPointerException("adminPassword");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.hostname = hostname;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.type = type;
        this.adminPassword = adminPassword;
        this.name = name;
    }

    public static enum Type {
        THREDDS,
        GEOSERVER,
        GEONETWORK;

    }
}

