/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.is;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.gcube.spatial.data.gis.Configuration;
import org.gcube.spatial.data.gis.is.LiveGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedGeoServerDescriptor
extends LiveGeoServerDescriptor {
    private static final Logger log = LoggerFactory.getLogger(CachedGeoServerDescriptor.class);
    private long lastDatastoreUpdate = 0L;
    private long lastWorkspaceUpdate = 0L;
    private long lastStylesUpdate = 0L;
    private long lastLayerCountUpdate = 0L;
    private HashMap<String, HashSet<String>> dataStores = null;
    private HashSet<String> workspaces = null;
    private HashSet<String> styles;
    private Long hostedLayerCount = 0L;

    public CachedGeoServerDescriptor(String url, String user, String password) {
        super(url, user, password);
    }

    @Override
    public synchronized Set<String> getDatastores(String workspace) throws MalformedURLException {
        if (this.dataStores == null || System.currentTimeMillis() - this.lastDatastoreUpdate > Configuration.getTTL("geoserver.cache.hostedLayers.TTL")) {
            log.trace("Loading datastores for {} ", (Object)this.getUrl());
            HashMap<String, HashSet<String>> toSet = new HashMap<String, HashSet<String>>();
            for (String ws : this.getWorkspaces()) {
                HashSet<String> currentWsDatastores = new HashSet<String>(super.getDatastores(ws));
                log.debug("Found {} ds in {} ws ", (Object)currentWsDatastores.size(), (Object)ws);
                toSet.put(ws, currentWsDatastores);
            }
            this.dataStores = toSet;
            this.lastDatastoreUpdate = System.currentTimeMillis();
        }
        return this.dataStores.get(workspace);
    }

    @Override
    public synchronized Long getHostedLayersCount() throws MalformedURLException {
        if (System.currentTimeMillis() - this.lastLayerCountUpdate > Configuration.getTTL("geoserver.cache.hostedLayers.TTL")) {
            log.trace("Loading layer count for {} ", (Object)this.getUrl());
            this.hostedLayerCount = super.getHostedLayersCount();
            log.debug("Found {} layers ", (Object)this.hostedLayerCount);
            this.lastLayerCountUpdate = System.currentTimeMillis();
        }
        return this.hostedLayerCount;
    }

    @Override
    public synchronized Set<String> getStyles() throws MalformedURLException {
        if (this.styles == null || System.currentTimeMillis() - this.lastStylesUpdate > Configuration.getTTL("geoserver.cache.hostedLayers.TTL")) {
            log.trace("Loading styles for {} ", (Object)this.getUrl());
            this.styles = new HashSet<String>(super.getStyles());
            log.debug("Found {} styles ", (Object)this.styles.size());
            this.lastStylesUpdate = System.currentTimeMillis();
        }
        return this.styles;
    }

    @Override
    public synchronized Set<String> getWorkspaces() throws MalformedURLException {
        if (this.workspaces == null || System.currentTimeMillis() - this.lastWorkspaceUpdate > Configuration.getTTL("geoserver.cache.hostedLayers.TTL")) {
            log.trace("Loading workspaces for {} ", (Object)this.getUrl());
            this.workspaces = new HashSet<String>(super.getWorkspaces());
            log.debug("Found {} workspaces", (Object)this.workspaces.size());
            this.lastWorkspaceUpdate = 0L;
        }
        return this.workspaces;
    }

    public void invalidateWorkspacesCache() {
        this.lastWorkspaceUpdate = 0L;
    }

    public void invalidateDatastoresCache() {
        this.lastDatastoreUpdate = 0L;
    }

    public void invalidateStylesCache() {
        this.lastStylesUpdate = 0L;
    }

    public void invalidateHostedLayersCountCache() {
        this.lastLayerCountUpdate = 0L;
    }

    @Override
    public void onChangedDataStores() {
        this.invalidateDatastoresCache();
    }

    @Override
    public void onChangedLayers() {
        this.invalidateHostedLayersCountCache();
    }

    @Override
    public void onChangedStyles() {
        this.invalidateStylesCache();
    }

    @Override
    public void onChangedWorkspaces() {
        this.invalidateWorkspacesCache();
        this.invalidateDatastoresCache();
    }
}

