package org.gcube.spatial.data.gis;

import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder.ProjectionPolicy;

import org.opengis.metadata.Metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;

import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.gis.model.GeoServerDescriptor;
import org.gcube.spatial.data.gis.model.InfrastructureCrawler;

public class GISInterface {

	private static final long MAX_GEOSERVER_CACHE_TIME=2*60*1000;
	
	public static GISInterface get() throws Exception{
		return new GISInterface();
	}

	
	//************ INSTANCE
	
	
	
	
	private GISInterface() throws Exception{
		
	}
	
	//***************** GEONETWORK READ METHODS
	
//	public GNSearchResponse query(GNSearchRequest request)
//			throws GNLibException, GNServerException, Exception{
//		return getGN().query(request);
//	}
//	
//	public GNSearchResponse query(File request)
//			throws GNLibException, GNServerException, Exception{
//		return getGN().query(request);
//	}
//	
//	public Metadata getById(long id) throws GNLibException,
//			GNServerException, JAXBException, Exception {
//		return getGN().getById(id);
//	}
//	
//	public Metadata getById(String UUID) throws GNLibException,
//			GNServerException, JAXBException, Exception  {
//		return getGN().getById(UUID);
//	}
	
	//****************** GEONETWORK WRITE METHODS
	
//	public void deleteMetadata(long id) throws GNLibException,
//	GNServerException, AuthorizationException, Exception {
//		getGN().deleteMetadata(id);
//	}
//	
//	public void setPrivileges(long metadataId, GNPrivConfiguration cfg)
//			throws GNLibException, GNServerException, AuthorizationException,Exception{
//		getGN().setPrivileges(metadataId, cfg);
//	}
//	
//	public long insertMetadata(GNInsertConfiguration configuration,
//			File metadataFile) throws GNLibException, GNServerException,
//			AuthorizationException,Exception{
//		return getGN().insertMetadata(configuration, metadataFile);
//	}
//	
//	public long insertMetadata(GNInsertConfiguration configuration,
//			Metadata meta) throws GNLibException, GNServerException,
//			AuthorizationException, IOException, JAXBException,Exception{
//		return getGN().insertMetadata(configuration, meta);
//	}
//
//	public long insertMetadata(File requestFile) throws GNLibException,
//			GNServerException, AuthorizationException,Exception{
//		return getGN().insertMetadata(requestFile);
//	}
//
//	public long insertMetadata(Metadata meta) throws GNLibException,
//			GNServerException, AuthorizationException, IOException,
//			JAXBException,Exception{
//		return getGN().insertMetadata(meta);
//	}
//
//	public void updateMetadata(long id, File metadataFile)
//			throws GNLibException, GNServerException, AuthorizationException,Exception{
//		getGN().updateMetadata(id, metadataFile);
//	}
//
//	public void updateMetadata(long id, Metadata meta) throws GNLibException,
//			GNServerException, AuthorizationException, IOException,
//			JAXBException,Exception{
//		getGN().updateMetadata(id, meta);
//	}
	
	//*******************READER getter METHODS
	
	public GeoNetworkReader getGeoNetworkReader() throws Exception{
		return getGN();
	}
	
	public GeoNetworkPublisher getGeoNewtorkPublisher()throws Exception{
		return getGN();
	}
	
	public GeoServerRESTReader getGeoServerReader(ResearchMethod method,boolean forceRefresh) throws Exception{
		GeoServerDescriptor desc=getGeoServerSet(forceRefresh).last();
		return getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getReader();
	}
	
	public GeoServerRESTReader getGeoServerReader(String url,String user,String password) throws IllegalArgumentException, MalformedURLException{
		return getGeoServerManager(url, user, password).getReader();
	}
	
	public GeoServerRESTReader getGeoServerReader(String url) throws MalformedURLException{
		return new GeoServerRESTReader(url);
	}
	
	//******************* Complex logic
	
	public void addGeoTIFF(String workspace, String storeName, String coverageName,
			File geotiff,String srs,
			ProjectionPolicy policy,String defaultStyle, double[] bbox, 
			Metadata geoNetworkMeta) throws FileNotFoundException, IllegalArgumentException, MalformedURLException,Exception{
		GeoServerDescriptor desc=getGeoServerSet(false).last();
		GeoServerRESTPublisher publisher=getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
		boolean publishResult = publisher.publishGeoTIFF(workspace, storeName, coverageName, geotiff, srs, policy, defaultStyle, bbox);
	}
	
	
	
	
	//************ PRIVATE
	
	private GeoNetworkPublisher geoNetwork=null;
	private ConcurrentSkipListSet<GeoServerDescriptor> geoservers=new ConcurrentSkipListSet<GeoServerDescriptor>();
	private long lastAccessedTime=0l;
	
	private synchronized SortedSet<GeoServerDescriptor> getGeoServerSet(boolean forceRefresh) throws Exception{
		if(forceRefresh||geoservers.size()==0||System.currentTimeMillis()-lastAccessedTime>MAX_GEOSERVER_CACHE_TIME){
			geoservers.clear();
			geoservers.addAll(InfrastructureCrawler.queryforGeoServer());
			lastAccessedTime=System.currentTimeMillis();
		}
		return geoservers;
	}
	
	private synchronized GeoNetworkPublisher getGN() throws Exception{
		if(geoNetwork==null) geoNetwork=GeoNetwork.get();
		return geoNetwork;
	}	
	
	private GeoServerRESTManager getGeoServerManager(String url,String user,String password) throws IllegalArgumentException, MalformedURLException{
		return new GeoServerRESTManager(new URL(url), user, password);
	}
	
	
	
}
