package org.gcube.spatial.data.geoutility.wfs;

import java.util.List;

import org.gcube.spatial.data.geoutility.shared.wfs.WFSParameter;

/**
 * The Class WFSQueryBuilder.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Jan 28, 2022
 */
public class WFSQueryBuilder {

	private String query = "";

	/**
	 * Instantiates a new WFS query builder.
	 */
	public WFSQueryBuilder() {

	}

	/**
	 * Adds the parameter.
	 *
	 * @param param the param
	 * @param value the value
	 */
	public void addParameter(WFSParameter param, String value) {

		if (!query.isEmpty())
			query += "&";

		query += param + "=" + value;
	}

	/**
	 * Adds the parameter.
	 *
	 * @param param    the param
	 * @param values   the values
	 * @param separtor the separtor
	 */
	public void addParameter(WFSParameter param, List<String> values, String separtor) {

		if (!query.isEmpty())
			query += "&";

		String value = "";
		for (int i = 0; i < values.size() - 1; i++) {
			value += values.get(i) + separtor;
		}

		value += values.get(values.size() - 1);

		query += param + "=" + value;
	}

	/**
	 * Gets the query.
	 *
	 * @return the query
	 */
	public String getQuery() {
		return query;
	}

}
