/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients.geoserver;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.spatial.data.clients.AbstractGenericRESTClient;
import org.gcube.spatial.data.clients.geoserver.GSRESTClient;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSRESTClientImpl
extends AbstractGenericRESTClient
implements GSRESTClient {
    private static final Logger log = LoggerFactory.getLogger(GSRESTClientImpl.class);
    private static final String API_BASE_PATH = "rest";
    private static final String WS_BASE_PATH = "workspaces";
    private static final String DATASTORE_BASE_PATH = "datastores";
    private static final String STYLES_BASE_PATH = "styles";
    private static final String LAYERS_BASE_PATH = "layers";
    private static final String FEATURES_BASE_PATH = "featuretype";
    static Configuration JSON_PATH_ALWAYS_LIST_CONFIG = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();

    public GSRESTClientImpl(ConnectionDescriptor conn) {
        super(conn);
        this.setBasePath(API_BASE_PATH);
    }

    @Override
    public JSONObject getWorkspaces() throws RemoteException, Exception {
        return (JSONObject)this.get(WS_BASE_PATH, JSONObject.class);
    }

    @Override
    public JSONObject getWorkspace(String workspace) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + workspace, JSONObject.class);
    }

    @Override
    public JSONObject getDataStoresInWorkspace(String ws) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + ws + "/" + DATASTORE_BASE_PATH, JSONObject.class);
    }

    @Override
    public JSONObject getStyles() throws RemoteException, Exception {
        return (JSONObject)this.get(STYLES_BASE_PATH, JSONObject.class);
    }

    @Override
    public JSONObject getStylesByLayer(String layer) throws RemoteException, Exception {
        return (JSONObject)this.get("layers/" + layer + "/" + STYLES_BASE_PATH, JSONObject.class);
    }

    @Override
    public JSONObject getStylesInWorkspace(String ws) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + ws + "/" + STYLES_BASE_PATH, JSONObject.class);
    }

    @Override
    public List<String> getWorkspaceNames() throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getWorkspaces().toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getDataStoresNamesInWorkspace(String ws) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getDataStoresInWorkspace(ws).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNames() throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStyles().toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNamesinWorkspace(String ws) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStylesInWorkspace(ws).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getStylesNamesByLayer(String layer) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.getStylesByLayer(layer).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public JSONObject getDataStore(String workspace, String dsName) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + workspace + "/" + DATASTORE_BASE_PATH + "/" + dsName, JSONObject.class);
    }

    @Override
    public String getSLD(String styleName) throws RemoteException, Exception {
        return (String)this.get("styles/" + styleName, String.class, "application/vnd.ogc.sld+xml");
    }

    @Override
    public JSONObject getFeatureType(String workspace, String featureName) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + workspace + "/" + FEATURES_BASE_PATH + "/" + featureName, JSONObject.class);
    }

    @Override
    public List<String> getFeatureTypesInDataStore(String workspace, String datastore) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.get("workspaces/" + workspace + "/" + DATASTORE_BASE_PATH + "/" + datastore + "/" + FEATURES_BASE_PATH));
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getFeatureTypesInWorkspace(String workspace) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.get("workspaces/" + workspace + "/" + FEATURES_BASE_PATH));
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public JSONObject getLayer(String layerName) throws RemoteException, Exception {
        return (JSONObject)this.get("layers/" + layerName, JSONObject.class);
    }

    @Override
    public JSONObject getLayerInWorkspace(String ws, String layerName) throws RemoteException, Exception {
        return (JSONObject)this.get("workspaces/" + ws + "/" + LAYERS_BASE_PATH + "/" + layerName, JSONObject.class);
    }

    @Override
    public List<String> getLayers() throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.get(LAYERS_BASE_PATH).toString());
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public List<String> getLayers(String workspace) throws RemoteException, Exception {
        DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(this.get("workspaces/" + workspace + "/" + LAYERS_BASE_PATH));
        return (List)sourceCtx.read("$..name", new Predicate[0]);
    }

    @Override
    public void deleteWorkspace(String ws, boolean recurse) throws RemoteException, Exception {
        GSRESTClientImpl.check((GXInboundResponse)this.resolve().path("workspaces/" + ws).queryParams(Collections.singletonMap("recurse", new Object[]{recurse})).delete(), null);
    }

    @Override
    public void deleteStyle(String style, boolean purgeSLD, boolean updateReferences) throws RemoteException, Exception {
        HashMap<String, Object[]> params = new HashMap<String, Object[]>();
        params.put("recurse", new Object[]{updateReferences});
        params.put("purge", new Object[]{purgeSLD});
        GSRESTClientImpl.check((GXInboundResponse)this.resolve().path("styles/" + style).queryParams(params).delete(), null);
    }

    @Override
    public void deleteDataStore(String ds, boolean recurse) throws RemoteException, Exception {
        GSRESTClientImpl.check((GXInboundResponse)this.resolve().path("datastores/" + ds).queryParams(Collections.singletonMap("recurse", new Object[]{recurse})).delete(), null);
    }

    @Override
    public void deleteLayer(String layer, boolean recurse) throws RemoteException, Exception {
        GSRESTClientImpl.check((GXInboundResponse)this.resolve().path("datastores/" + layer).queryParams(Collections.singletonMap("recurse", new Object[]{recurse})).delete(), null);
    }

    @Override
    public void createWorkspace(String ws) throws RemoteException, Exception {
        JSONObject obj = new JSONObject();
        obj.put((Object)"name", (Object)ws);
        this.post(WS_BASE_PATH, Entity.entity((Object)new JSONObject(Collections.singletonMap("workspace", obj)), (String)"application/json"));
    }

    @Override
    public void publishDataStore(String ws, JSONObject parameters) throws Exception {
        this.post("workspaces/" + ws + "/" + DATASTORE_BASE_PATH, Entity.entity((Object)parameters, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public boolean exist() {
        try {
            GXWebTargetAdapterRequest request = GXWebTargetAdapterRequest.newHTTPSRequest((String)this.getConn().getEndpoint());
            GSRESTClientImpl.check((GXInboundResponse)request.get(), null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

