package org.gcube.spatial.data.clients.geoserver;

import java.io.InputStream;
import java.util.List;

import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.json.simple.JSONObject;

public interface GSRESTClient {

	
	// ********** READ OPS 
	
	// WS
	
	public JSONObject getWorkspaces()throws RemoteException,Exception;
	public List<String> getWorkspaceNames()throws RemoteException,Exception;
	public JSONObject getWorkspace(String workspace)throws RemoteException, Exception;
	
	// DS
	public JSONObject getDataStoresInWorkspace(String ws)throws RemoteException,Exception;
	public List<String> getDataStoresNamesInWorkspace(String ws)throws RemoteException,Exception;
	
	// SLD
	public JSONObject getStyles()throws RemoteException,Exception;
	public List<String> getStylesNames()throws RemoteException,Exception;
	public JSONObject getStylesInWorkspace(String ws)throws RemoteException,Exception;
	public List<String> getStylesNamesinWorkspace(String ws)throws RemoteException,Exception;
	public JSONObject getStylesByLayer(String layer)throws RemoteException,Exception;
	public List<String> getStylesNamesByLayer(String layer)throws RemoteException,Exception;
	
	// *********** CREATE OPS
	public void createWorkspace(String ws)throws RemoteException,Exception;
//	
//	public void createStyle(String name,String content)throws RemoteException,Exception;
//	public void createStyle(String name,InputStream content)throws RemoteException,Exception;
//	
	// publish DB layer
	// publish local files
	
	// create store for postgis db
	
//	// +********** DELETE OPS 
	public void deleteWorkspace(String ws)throws RemoteException,Exception;
	public void deleteStyle(String style)throws RemoteException,Exception;
	public void deleteDataStore(String ds)throws RemoteException,Exception;
	public void deleteLayer(String layer)throws RemoteException,Exception;
}
