package org.gcube.socialnetworking.token;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class URLToken extends ReplaceableToken {
	
	private boolean replaced;
	
	public URLToken(Token token, URL url) {
		super(token);
		this.tokenReplacement = "___URL____";
	}
	
	
	public static URL isURL(String string) {
		if(string.startsWith("www.")) {
			string = "http://" + string;
		}
		try {
			return new URL(string);
		} catch(MalformedURLException e) {
			// not an URL
			return null;
		}
		
	}
	
	public String getTokenReplacement() {
		if(!replaced) {
			Map<String, String> anchorAttibutes = new HashMap<>(1);
			anchorAttibutes.put("target", "_blank");
			tokenReplacement = ReplaceableToken.createLink(token, token, anchorAttibutes);
			replaced = true;
		}
		return super.getTokenReplacement();
	}
	
}
