package org.gcube.socialnetworking.token;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;

public class ReplaceableToken extends Token {

	protected String tokenReplacement; 
	
	protected String createHref(String baseURL, String attributeName, String attributeValue) {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append(baseURL);
		stringBuilder.append("?");
		stringBuilder.append(new String(Base64.encodeBase64(attributeName.getBytes())));
		stringBuilder.append("=");
		stringBuilder.append(new String(Base64.encodeBase64(attributeValue.getBytes())));
		return stringBuilder.toString();
		
	}
	
	protected String createLink(String linkTarget, String linkValue, Map<String, String> additionalAttributes) {
		Map<String, String> attributes = new HashMap<>(); 
		if(additionalAttributes!=null) {
			attributes.putAll(additionalAttributes);
		}
		attributes.put("class", "link");
		if(!attributes.containsKey("style")) {
			attributes.put("style", "font-size:14px;");
		}
		attributes.put("href", linkTarget);
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("<a ");
		for(String key : attributes.keySet()) {
			stringBuilder.append(key);
			stringBuilder.append("=\"");
			stringBuilder.append(attributes.get(key));
			stringBuilder.append("\" ");
		}
		stringBuilder.append(">");
		stringBuilder.append(linkValue);
		stringBuilder.append("</a>");
		return stringBuilder.toString();
	}
	
	
	public ReplaceableToken(Token token) {
		super(token.token, token.delimiter, token.start, token.end);
		this.tokenReplacement = token.token;
	}
	
	public ReplaceableToken(Token token, String tokenReplacement) {
		super(token.token, token.delimiter, token.start, token.end);
		this.tokenReplacement = tokenReplacement;
	}

	@Override
	public String getDelimiter() {
		return delimiter.replaceAll("(\r\n|\n)","<br/>");
	}
	
	public String getTokenReplacement() {
		return tokenReplacement;
	}
	
}
