package org.gcube.social_networking.socialutillibrary;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.gcube.socialnetworking.token.Token;

public class SocialStringTokenizer {

	private final String originalString;
	
	private Pattern pattern;
	private Matcher matcher;
	
	private List<Token> tokens;
	
	public SocialStringTokenizer(String string) {
		this.originalString = string;
		this.pattern = Pattern.compile("\\s");
	    this.matcher = pattern.matcher(originalString);
	}

	public List<Token> getTokens() {
		if(tokens==null) {
			tokens = new ArrayList<>();
			int tokenStart = 0;
			while(matcher.find()) {
				int tokenEnd = matcher.start();
				String tokenString = originalString.substring(tokenStart, tokenEnd);
				int delimiterStart = tokenEnd;
				int delimiterEnd = matcher.end(); 
				String delimiter = originalString.substring(delimiterStart, delimiterEnd);
				Token token = new Token(tokenString, delimiter, tokenStart, tokenEnd);
				tokens.add(token);
				tokenStart = delimiterEnd;
			}
			if(tokenStart!=originalString.length()){
				int tokenEnd = originalString.length();
				String tokenString = originalString.substring(tokenStart, tokenEnd);
				Token token = new Token(tokenString, "", tokenStart, tokenEnd);
				tokens.add(token);
			}
		}
		return tokens;
	}
	
}
