/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AuthenticationException
extends DriverException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public AuthenticationException(InetSocketAddress address, String message) {
        super(String.format("Authentication error on host %s: %s", address, message));
        this.address = address;
    }

    private AuthenticationException(String message, Throwable cause, InetSocketAddress address) {
        super(message, cause);
        this.address = address;
    }

    public InetAddress getHost() {
        return this.address.getAddress();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public DriverException copy() {
        return new AuthenticationException(this.getMessage(), this, this.address);
    }
}

