/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class ArrayBackedRow
implements Row {
    private final ColumnDefinitions metadata;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata, List<ByteBuffer> data) {
        this.metadata = metadata;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new ArrayBackedRow(metadata, data);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public boolean isNull(int i) {
        this.metadata.checkBounds(i);
        return this.data.get(i) == null;
    }

    @Override
    public boolean isNull(String name) {
        return this.isNull(this.metadata.getFirstIdx(name));
    }

    @Override
    public boolean getBool(int i) {
        this.metadata.checkType(i, DataType.Name.BOOLEAN);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        return TypeCodec.BooleanCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public boolean getBool(String name) {
        return this.getBool(this.metadata.getFirstIdx(name));
    }

    @Override
    public int getInt(int i) {
        this.metadata.checkType(i, DataType.Name.INT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0;
        }
        return TypeCodec.IntCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(this.metadata.getFirstIdx(name));
    }

    @Override
    public long getLong(int i) {
        this.metadata.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        return TypeCodec.LongCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(this.metadata.getFirstIdx(name));
    }

    @Override
    public Date getDate(int i) {
        this.metadata.checkType(i, DataType.Name.TIMESTAMP);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.DateCodec.instance.deserialize(value);
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(this.metadata.getFirstIdx(name));
    }

    @Override
    public float getFloat(int i) {
        this.metadata.checkType(i, DataType.Name.FLOAT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0.0f;
        }
        return TypeCodec.FloatCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(this.metadata.getFirstIdx(name));
    }

    @Override
    public double getDouble(int i) {
        this.metadata.checkType(i, DataType.Name.DOUBLE);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0.0;
        }
        return TypeCodec.DoubleCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(this.metadata.getFirstIdx(name));
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        this.metadata.checkBounds(i);
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return null;
        }
        return value.duplicate();
    }

    @Override
    public ByteBuffer getBytesUnsafe(String name) {
        return this.getBytesUnsafe(this.metadata.getFirstIdx(name));
    }

    @Override
    public ByteBuffer getBytes(int i) {
        this.metadata.checkType(i, DataType.Name.BLOB);
        return this.getBytesUnsafe(i);
    }

    @Override
    public ByteBuffer getBytes(String name) {
        return this.getBytes(this.metadata.getFirstIdx(name));
    }

    @Override
    public String getString(int i) {
        DataType.Name type = this.metadata.checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return null;
        }
        return type == DataType.Name.ASCII ? TypeCodec.StringCodec.asciiInstance.deserialize(value) : TypeCodec.StringCodec.utf8Instance.deserialize(value);
    }

    @Override
    public String getString(String name) {
        return this.getString(this.metadata.getFirstIdx(name));
    }

    @Override
    public BigInteger getVarint(int i) {
        this.metadata.checkType(i, DataType.Name.VARINT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.BigIntegerCodec.instance.deserialize(value);
    }

    @Override
    public BigInteger getVarint(String name) {
        return this.getVarint(this.metadata.getFirstIdx(name));
    }

    @Override
    public BigDecimal getDecimal(int i) {
        this.metadata.checkType(i, DataType.Name.DECIMAL);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.DecimalCodec.instance.deserialize(value);
    }

    @Override
    public BigDecimal getDecimal(String name) {
        return this.getDecimal(this.metadata.getFirstIdx(name));
    }

    @Override
    public UUID getUUID(int i) {
        DataType.Name type = this.metadata.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return type == DataType.Name.UUID ? TypeCodec.UUIDCodec.instance.deserialize(value) : TypeCodec.TimeUUIDCodec.instance.deserialize(value);
    }

    @Override
    public UUID getUUID(String name) {
        return this.getUUID(this.metadata.getFirstIdx(name));
    }

    @Override
    public InetAddress getInet(int i) {
        this.metadata.checkType(i, DataType.Name.INET);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.InetCodec.instance.deserialize(value);
    }

    @Override
    public InetAddress getInet(String name) {
        return this.getInet(this.metadata.getFirstIdx(name));
    }

    @Override
    public <T> List<T> getList(int i, Class<T> elementsClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is not of list type", this.metadata.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a list of %s (CQL type %s), cannot be retrieve as a list of %s", this.metadata.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList((List)type.codec().deserialize(value));
    }

    @Override
    public <T> List<T> getList(String name, Class<T> elementsClass) {
        return this.getList(this.metadata.getFirstIdx(name), elementsClass);
    }

    @Override
    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is not of set type", this.metadata.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a set of %s (CQL type %s), cannot be retrieve as a set of %s", this.metadata.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)type.codec().deserialize(value));
    }

    @Override
    public <T> Set<T> getSet(String name, Class<T> elementsClass) {
        return this.getSet(this.metadata.getFirstIdx(name), elementsClass);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is not of map type", this.metadata.getName(i)));
        }
        Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
        Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
        if (!keysClass.isAssignableFrom(expectedKeysClass) || !valuesClass.isAssignableFrom(expectedValuesClass)) {
            throw new InvalidTypeException(String.format("Column %s is a map of %s->%s (CQL type %s), cannot be retrieve as a map of %s->%s", this.metadata.getName(i), expectedKeysClass, expectedValuesClass, type, keysClass, valuesClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)type.codec().deserialize(value));
    }

    @Override
    public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        return this.getMap(this.metadata.getFirstIdx(name), keysClass, valuesClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.metadata.getType(i).codec().deserialize(bb).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

