/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;

public abstract class AbstractSession
implements Session {
    @Override
    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    @Override
    public ResultSet execute(String query, Object ... values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.executeAsync(statement).getUninterruptibly();
    }

    @Override
    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public PreparedStatement prepare(String query) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(query));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(statement));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(final RegularStatement statement) {
        if (statement.getValues() != null) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        ListenableFuture<PreparedStatement> prepared = this.prepareAsync(statement.toString());
        return Futures.transform(prepared, (Function)new Function<PreparedStatement, PreparedStatement>(){

            public PreparedStatement apply(PreparedStatement prepared) {
                ByteBuffer routingKey = statement.getRoutingKey();
                if (routingKey != null) {
                    prepared.setRoutingKey(routingKey);
                }
                prepared.setConsistencyLevel(statement.getConsistencyLevel());
                if (statement.isTracing()) {
                    prepared.enableTracing();
                }
                prepared.setRetryPolicy(statement.getRetryPolicy());
                return prepared;
            }
        });
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

