/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.datastax.driver.core.PreparedStatement;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class StatementCache {
    private final ConcurrentHashMap<Integer, PreparedStatement> statementCache = new ConcurrentHashMap();
    private static final StatementCache Instance = new StatementCache();

    private StatementCache() {
    }

    public PreparedStatement getStatement(Integer id) {
        return this.statementCache.get(id);
    }

    public PreparedStatement getStatement(Integer id, Callable<PreparedStatement> func) {
        PreparedStatement stmt = this.statementCache.get(id);
        if (stmt == null) {
            try {
                stmt = func.call();
                this.statementCache.putIfAbsent(id, stmt);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return stmt;
    }

    public static StatementCache getInstance() {
        return Instance;
    }
}

