/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.util;

import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import java.nio.ByteBuffer;

public class CFQueryContext<K, C> {
    private final ColumnFamily<K, C> columnFamily;
    private final Object rowKey;
    private RetryPolicy retryPolicy;
    private ConsistencyLevel clLevel;

    public CFQueryContext(ColumnFamily<K, C> cf) {
        this(cf, null, null, null);
    }

    public CFQueryContext(ColumnFamily<K, C> cf, K rKey) {
        this(cf, rKey, null, null);
    }

    public CFQueryContext(ColumnFamily<K, C> cf, K rKey, RetryPolicy retry, ConsistencyLevel cl) {
        this.columnFamily = cf;
        this.rowKey = this.checkRowKey(rKey);
        this.retryPolicy = retry;
        this.clLevel = cl;
    }

    public ColumnFamily<K, C> getColumnFamily() {
        return this.columnFamily;
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    public void setRetryPolicy(RetryPolicy retry) {
        this.retryPolicy = retry;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setConsistencyLevel(ConsistencyLevel cl) {
        this.clLevel = cl;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.clLevel;
    }

    public Object checkRowKey(K rKey) {
        if (rKey == null) {
            return null;
        }
        CqlColumnFamilyDefinitionImpl cfDef = (CqlColumnFamilyDefinitionImpl)this.columnFamily.getColumnFamilyDefinition();
        if (cfDef.getKeyValidationClass().contains("BytesType")) {
            if (rKey instanceof ByteBuffer) {
                return rKey;
            }
            return this.columnFamily.getKeySerializer().toByteBuffer(rKey);
        }
        return rKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CF=").append(this.columnFamily.getName());
        sb.append(" RowKey: ").append(this.rowKey);
        sb.append(" RetryPolicy: ").append(this.retryPolicy);
        sb.append(" ConsistencyLevel: ").append(this.clLevel);
        return sb.toString();
    }
}

