/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.direct;

import com.datastax.driver.core.ResultSet;
import com.netflix.astyanax.cql.CqlSchema;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.cql.reads.model.CqlRowListImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Rows;
import java.util.List;

public class DirectCqlStatementResultImpl
implements CqlStatementResult {
    private final ResultSet rs;

    public DirectCqlStatementResultImpl(ResultSet rs) {
        this.rs = rs;
    }

    public long asCount() {
        return this.rs.one().getLong(0);
    }

    public <K, C> Rows<K, C> getRows(ColumnFamily<K, C> columnFamily) {
        List rows = this.rs.all();
        return new CqlRowListImpl<K, C>(rows, columnFamily);
    }

    public CqlSchema getSchema() {
        return new DirectCqlSchema(this.rs);
    }

    public static class DirectCqlSchema
    implements CqlSchema {
        private final ResultSet rs;

        public DirectCqlSchema(ResultSet result) {
            this.rs = result;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }
    }
}

