/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolConfigurationImpl;
import java.util.concurrent.TimeUnit;

public class JavaDriverConfigBuilder {
    private LoadBalancingPolicy loadBalancingPolicy = new RoundRobinPolicy();
    private ReconnectionPolicy reconnectionPolicy = new ExponentialReconnectionPolicy(1000L, 600000L);
    private RetryPolicy retryPolicy = DefaultRetryPolicy.INSTANCE;
    private int nativeProtocolPort = -1;
    private PoolingOptions poolingOptions = new PoolingOptions();
    private SocketOptions socketOptions = new SocketOptions();
    private boolean jmxReportingEnabled = true;
    private QueryOptions queryOptions = new QueryOptions();

    public JavaDriverConnectionPoolConfigurationImpl build() {
        Policies policies = new Policies(this.loadBalancingPolicy, this.reconnectionPolicy, this.retryPolicy);
        ProtocolOptions protocolOptions = this.nativeProtocolPort == -1 ? new ProtocolOptions() : new ProtocolOptions(this.nativeProtocolPort);
        PoolingOptions poolOptions = this.poolingOptions;
        SocketOptions sockOptions = this.socketOptions;
        MetricsOptions metricsOptions = new MetricsOptions(this.jmxReportingEnabled);
        QueryOptions qOptions = this.queryOptions;
        return new JavaDriverConnectionPoolConfigurationImpl(new Configuration(policies, protocolOptions, poolOptions, sockOptions, metricsOptions, qOptions));
    }

    public JavaDriverConfigBuilder withLoadBalancingPolicy(LoadBalancingPolicy lbPolicy) {
        this.loadBalancingPolicy = lbPolicy;
        return this;
    }

    public JavaDriverConfigBuilder withReconnectionPolicy(ReconnectionPolicy reconnectPolicy) {
        this.reconnectionPolicy = reconnectPolicy;
        return this;
    }

    public JavaDriverConfigBuilder withRetryPolicy(RetryPolicy rPolicy) {
        this.retryPolicy = rPolicy;
        return this;
    }

    public JavaDriverConfigBuilder withPort(int nativePort) {
        this.nativeProtocolPort = nativePort;
        return this;
    }

    public JavaDriverConfigBuilder withCoreConnsPerHost(HostDistance distance, int coreConnections) {
        this.poolingOptions.setCoreConnectionsPerHost(distance, coreConnections);
        return this;
    }

    public JavaDriverConfigBuilder withMaxConnsPerHost(HostDistance distance, int maxConnections) {
        this.poolingOptions.setMaxConnectionsPerHost(distance, maxConnections);
        return this;
    }

    public JavaDriverConfigBuilder withMinRequestsPerConnection(HostDistance distance, int minRequests) {
        this.poolingOptions.setMinSimultaneousRequestsPerConnectionThreshold(distance, minRequests);
        return this;
    }

    public JavaDriverConfigBuilder withMaxRequestsPerConnection(HostDistance distance, int maxRequests) {
        this.poolingOptions.setMaxSimultaneousRequestsPerConnectionThreshold(distance, maxRequests);
        return this;
    }

    public JavaDriverConfigBuilder withConnectTimeout(int timeout, TimeUnit sourceUnit) {
        Long connectTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, sourceUnit);
        this.socketOptions.setConnectTimeoutMillis(connectTimeoutMillis.intValue());
        return this;
    }

    public JavaDriverConfigBuilder withReadTimeout(int timeout, TimeUnit sourceUnit) {
        Long readTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, sourceUnit);
        this.socketOptions.setReadTimeoutMillis(readTimeoutMillis.intValue());
        return this;
    }

    public JavaDriverConfigBuilder withKeepAlive(boolean keepAlive) {
        this.socketOptions.setKeepAlive(keepAlive);
        return this;
    }

    public JavaDriverConfigBuilder withReuseAddress(boolean reuseAddress) {
        this.socketOptions.setReuseAddress(reuseAddress);
        return this;
    }

    public JavaDriverConfigBuilder withSoLinger(int soLinger) {
        this.socketOptions.setSoLinger(soLinger);
        return this;
    }

    public JavaDriverConfigBuilder withTcpNoDelay(boolean tcpNoDelay) {
        this.socketOptions.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public JavaDriverConfigBuilder withReceiveBufferSize(int receiveBufferSize) {
        this.socketOptions.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public JavaDriverConfigBuilder withSendBufferSize(int sendBufferSize) {
        this.socketOptions.setSendBufferSize(sendBufferSize);
        return this;
    }

    public JavaDriverConfigBuilder withJmxReportingEnabled(boolean enabled) {
        this.jmxReportingEnabled = enabled;
        return this;
    }

    public JavaDriverConfigBuilder withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.queryOptions.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public JavaDriverConfigBuilder withSerialConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.queryOptions.setSerialConsistencyLevel(consistencyLevel);
        return this;
    }

    public JavaDriverConfigBuilder withFetchSize(int fetchSize) {
        this.queryOptions.setFetchSize(fetchSize);
        return this;
    }
}

