/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.OperationResult;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class CqlOperationResultImpl<R>
implements OperationResult<R> {
    private Host host;
    private R result;
    private int attemptCount = 0;
    private long durationMicros = 0L;

    public CqlOperationResultImpl(ResultSet rs, R result) {
        this.host = this.parseHostInfo(rs);
        this.result = result;
        this.durationMicros = this.parseDuration(rs);
    }

    private Host parseHostInfo(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        com.datastax.driver.core.Host fromHost = rs.getExecutionInfo().getQueriedHost();
        InetAddress add = fromHost.getAddress();
        Host toHost = new Host(add.getHostAddress(), -1);
        toHost.setRack(fromHost.getRack());
        return toHost;
    }

    private long parseDuration(ResultSet rs) {
        QueryTrace qt;
        ExecutionInfo info;
        if (rs != null && (info = rs.getExecutionInfo()) != null && (qt = info.getQueryTrace()) != null) {
            return qt.getDurationMicros();
        }
        return 0L;
    }

    public Host getHost() {
        return this.host;
    }

    public R getResult() {
        return this.result;
    }

    public long getLatency() {
        return this.durationMicros;
    }

    public long getLatency(TimeUnit units) {
        return units.convert(this.durationMicros, TimeUnit.MICROSECONDS);
    }

    public int getAttemptsCount() {
        return this.attemptCount;
    }

    public void setAttemptsCount(int count) {
        this.attemptCount = count;
    }
}

