/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

public class BinaryData {
    private static final ThreadLocal<Decoders> DECODERS = new ThreadLocal<Decoders>(){

        @Override
        protected Decoders initialValue() {
            return new Decoders();
        }
    };
    private static final ThreadLocal<HashData> HASH_DATA = new ThreadLocal<HashData>(){

        @Override
        protected HashData initialValue() {
            return new HashData();
        }
    };

    private BinaryData() {
    }

    public static int compare(byte[] b1, int s1, byte[] b2, int s2, Schema schema) {
        Decoders decoders = DECODERS.get();
        decoders.set(b1, s1, b1.length, b2, s2, b2.length);
        try {
            return BinaryData.compare(decoders, schema);
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private static int compare(Decoders d, Schema schema) throws IOException {
        BinaryDecoder d1 = d.d1;
        BinaryDecoder d2 = d.d2;
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), d1);
                        GenericDatumReader.skip(field.schema(), d2);
                        continue;
                    }
                    int c = BinaryData.compare(d, field.schema());
                    if (c == 0) continue;
                    return field.order() != Schema.Field.Order.DESCENDING ? c : -c;
                }
                return 0;
            }
            case ENUM: 
            case INT: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d2).readInt();
                return i1 == i2 ? 0 : (i1 > i2 ? 1 : -1);
            }
            case LONG: {
                long l1 = ((Decoder)d1).readLong();
                long l2 = ((Decoder)d2).readLong();
                return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
            }
            case ARRAY: {
                long i = 0L;
                long r1 = 0L;
                long r2 = 0L;
                long l1 = 0L;
                long l2 = 0L;
                block15: while (true) {
                    if (r1 == 0L) {
                        r1 = ((Decoder)d1).readLong();
                        if (r1 < 0L) {
                            r1 = -r1;
                            ((Decoder)d1).readLong();
                        }
                        l1 += r1;
                    }
                    if (r2 == 0L) {
                        r2 = ((Decoder)d2).readLong();
                        if (r2 < 0L) {
                            r2 = -r2;
                            ((Decoder)d2).readLong();
                        }
                        l2 += r2;
                    }
                    if (r1 == 0L || r2 == 0L) {
                        return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
                    }
                    long l = Math.min(l1, l2);
                    while (true) {
                        if (i >= l) continue block15;
                        int c = BinaryData.compare(d, schema.getElementType());
                        if (c != 0) {
                            return c;
                        }
                        ++i;
                        --r1;
                        --r2;
                    }
                    break;
                }
            }
            case MAP: {
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d2).readInt();
                if (i1 == i2) {
                    return BinaryData.compare(d, schema.getTypes().get(i1));
                }
                return i1 - i2;
            }
            case FIXED: {
                int size = schema.getFixedSize();
                int c = BinaryData.compareBytes(d.b1.getBuf(), d.b1.getPos(), size, d.b2.getBuf(), d.b2.getPos(), size);
                d.d1.skipFixed(size);
                d.d2.skipFixed(size);
                return c;
            }
            case STRING: 
            case BYTES: {
                int l1 = ((Decoder)d1).readInt();
                int l2 = ((Decoder)d2).readInt();
                int c = BinaryData.compareBytes(d.b1.getBuf(), d.b1.getPos(), l1, d.b2.getBuf(), d.b2.getPos(), l2);
                d.d1.skipFixed(l1);
                d.d2.skipFixed(l2);
                return c;
            }
            case FLOAT: {
                float f1 = ((Decoder)d1).readFloat();
                float f2 = ((Decoder)d2).readFloat();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case DOUBLE: {
                double f1 = ((Decoder)d1).readDouble();
                double f2 = ((Decoder)d2).readDouble();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case BOOLEAN: {
                boolean b1 = ((Decoder)d1).readBoolean();
                boolean b2 = ((Decoder)d2).readBoolean();
                return b1 == b2 ? 0 : (b1 ? 1 : -1);
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to compare!");
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int hashCode(byte[] bytes, int start, int length, Schema schema) {
        HashData data = HASH_DATA.get();
        data.set(bytes, start, length);
        try {
            return BinaryData.hashCode(data, schema);
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private static int hashCode(HashData data, Schema schema) throws IOException {
        BinaryDecoder decoder = data.decoder;
        switch (schema.getType()) {
            case RECORD: {
                int hashCode = 1;
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), decoder);
                        continue;
                    }
                    hashCode = hashCode * 31 + BinaryData.hashCode(data, field.schema());
                }
                return hashCode;
            }
            case ENUM: 
            case INT: {
                return ((Decoder)decoder).readInt();
            }
            case FLOAT: {
                return Float.floatToIntBits(((Decoder)decoder).readFloat());
            }
            case LONG: {
                long l = ((Decoder)decoder).readLong();
                return (int)(l ^ l >>> 32);
            }
            case DOUBLE: {
                long l = Double.doubleToLongBits(((Decoder)decoder).readDouble());
                return (int)(l ^ l >>> 32);
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                int hashCode = 1;
                long l = ((Decoder)decoder).readArrayStart();
                while (l != 0L) {
                    for (long i = 0L; i < l; ++i) {
                        hashCode = hashCode * 31 + BinaryData.hashCode(data, elementType);
                    }
                    l = ((Decoder)decoder).arrayNext();
                }
                return hashCode;
            }
            case MAP: {
                throw new AvroRuntimeException("Can't hashCode maps!");
            }
            case UNION: {
                return BinaryData.hashCode(data, schema.getTypes().get(((Decoder)decoder).readInt()));
            }
            case FIXED: {
                return BinaryData.hashBytes(1, data, schema.getFixedSize(), false);
            }
            case STRING: {
                return BinaryData.hashBytes(0, data, ((Decoder)decoder).readInt(), false);
            }
            case BYTES: {
                return BinaryData.hashBytes(1, data, ((Decoder)decoder).readInt(), true);
            }
            case BOOLEAN: {
                return ((Decoder)decoder).readBoolean() ? 1231 : 1237;
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to hashCode!");
    }

    private static int hashBytes(int init, HashData data, int len, boolean rev) throws IOException {
        int hashCode = init;
        byte[] bytes = data.bytes.getBuf();
        int start = data.bytes.getPos();
        int end = start + len;
        if (rev) {
            for (int i = end - 1; i >= start; --i) {
                hashCode = hashCode * 31 + bytes[i];
            }
        } else {
            for (int i = start; i < end; ++i) {
                hashCode = hashCode * 31 + bytes[i];
            }
        }
        data.decoder.skipFixed(len);
        return hashCode;
    }

    public static int skipLong(byte[] bytes, int start) {
        int i = start;
        byte b = bytes[i++];
        while ((b & 0x80) != 0) {
            b = bytes[i++];
        }
        return i;
    }

    private static class HashData {
        private final BinaryDecoder.BufferAccessor bytes;
        private final BinaryDecoder decoder = new BinaryDecoder(new byte[0], 0, 0);

        public HashData() {
            this.bytes = this.decoder.getBufferAccessor();
        }

        public void set(byte[] bytes, int start, int len) {
            this.decoder.init(bytes, start, len);
        }
    }

    private static class Decoders {
        private final BinaryDecoder.BufferAccessor b1;
        private final BinaryDecoder.BufferAccessor b2;
        private final BinaryDecoder d1 = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder d2 = new BinaryDecoder(new byte[0], 0, 0);

        public Decoders() {
            this.b1 = this.d1.getBufferAccessor();
            this.b2 = this.d2.getBufferAccessor();
        }

        public void set(byte[] data1, int off1, int len1, byte[] data2, int off2, int len2) {
            this.d1.init(data1, off1, len1);
            this.d2.init(data2, off2, len2);
        }
    }
}

