/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.uniqueness;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.locks.BusyLockException;
import com.netflix.astyanax.recipes.locks.ColumnPrefixDistributedRowLock;
import com.netflix.astyanax.recipes.locks.StaleLockException;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.recipes.uniqueness.UniquenessConstraint;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MultiRowUniquenessConstraint
implements UniquenessConstraint {
    private final Keyspace keyspace;
    private final List<ColumnPrefixDistributedRowLock<String>> locks = Lists.newArrayList();
    private Integer ttl = null;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.CL_LOCAL_QUORUM;
    private String lockColumn;
    private String prefix = "_LOCK_";

    public MultiRowUniquenessConstraint(Keyspace keyspace) {
        this.keyspace = keyspace;
        this.lockColumn = TimeUUIDUtils.getUniqueTimeUUIDinMicros().toString();
    }

    public MultiRowUniquenessConstraint withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public MultiRowUniquenessConstraint withColumnPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public MultiRowUniquenessConstraint withLockId(String column) {
        this.lockColumn = column;
        return this;
    }

    public MultiRowUniquenessConstraint withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public MultiRowUniquenessConstraint withRow(ColumnFamily<String, String> columnFamily, String rowKey) {
        this.locks.add(new ColumnPrefixDistributedRowLock<String>(this.keyspace, columnFamily, rowKey));
        return this;
    }

    public String getLockColumn() {
        return this.lockColumn;
    }

    @Override
    public void acquire() throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(null);
    }

    @Override
    public void acquireAndApplyMutation(Function<MutationBatch, Boolean> callback) throws NotUniqueException, Exception {
        long now = TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        try {
            MutationBatch m = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
            for (ColumnPrefixDistributedRowLock<String> lock : this.locks) {
                lock.withConsistencyLevel(this.consistencyLevel).withColumnPrefix(this.prefix).withLockId(this.lockColumn).fillLockMutation(m, now, this.ttl);
            }
            m.execute();
            for (ColumnPrefixDistributedRowLock<String> lock : this.locks) {
                lock.verifyLock(now);
            }
            m = this.keyspace.prepareMutationBatch();
            for (ColumnPrefixDistributedRowLock<String> lock : this.locks) {
                lock.fillLockMutation(m, null, null);
            }
            if (callback != null) {
                callback.apply((Object)m);
            }
            m.execute();
        }
        catch (BusyLockException e) {
            this.release();
            throw new NotUniqueException(e);
        }
        catch (StaleLockException e) {
            this.release();
            throw new NotUniqueException(e);
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    @Deprecated
    public void acquireAndMutate(final MutationBatch mutation) throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(new Function<MutationBatch, Boolean>(){

            public Boolean apply(MutationBatch input) {
                if (mutation != null) {
                    input.mergeShallow(mutation);
                }
                return true;
            }
        });
    }

    @Override
    public void release() throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch();
        for (ColumnPrefixDistributedRowLock<String> lock : this.locks) {
            lock.fillReleaseMutation(m, false);
        }
        m.execute();
    }
}

