/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildFilteredTermsEnum;
import org.elasticsearch.index.fielddata.plain.ParentChildIntersectTermsEnum;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildIndexFieldData
extends AbstractIndexFieldData<AtomicParentChildFieldData>
implements IndexParentChildFieldData,
DocumentTypeListener {
    private final NavigableSet<String> parentTypes;
    private final CircuitBreakerService breakerService;
    private final Object lock = new Object();

    public ParentChildIndexFieldData(Index index, Settings indexSettings, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, MapperService mapperService, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
        if (Version.indexCreated(indexSettings).before(Version.V_2_0_0_beta1)) {
            this.parentTypes = new TreeSet<String>();
            for (DocumentMapper documentMapper : mapperService.docMappers(false)) {
                this.beforeCreate(documentMapper);
            }
            mapperService.addTypeListener(this);
        } else {
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            for (DocumentMapper mapper : mapperService.docMappers(false)) {
                ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
                if (!parentFieldMapper.active()) continue;
                builder.add((Object)parentFieldMapper.type());
            }
            this.parentTypes = builder.build();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public AtomicParentChildFieldData load(LeafReaderContext context) {
        if (Version.indexCreated(this.indexSettings()).onOrAfter(Version.V_2_0_0_beta1)) {
            final LeafReader reader = context.reader();
            return new AbstractAtomicParentChildFieldData(){

                @Override
                public Set<String> types() {
                    return ParentChildIndexFieldData.this.parentTypes;
                }

                @Override
                public SortedDocValues getOrdinalsValues(String type) {
                    try {
                        return DocValues.getSorted((LeafReader)reader, (String)ParentFieldMapper.joinField(type));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("cannot load join doc values field for type [" + type + "]", e);
                    }
                }

                public long ramBytesUsed() {
                    return 0L;
                }

                public Collection<Accountable> getChildResources() {
                    return Collections.emptyList();
                }

                @Override
                public void close() throws ElasticsearchException {
                }
            };
        }
        try {
            return (AtomicParentChildFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractAtomicParentChildFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        TreeSet<BytesRef> parentTypes = new TreeSet<BytesRef>();
        Object object = this.lock;
        synchronized (object) {
            for (String parentType : this.parentTypes) {
                parentTypes.add(new BytesRef((CharSequence)parentType));
            }
        }
        boolean success = false;
        ParentChildAtomicFieldData data = null;
        ParentChildFilteredTermsEnum termsEnum = new ParentChildFilteredTermsEnum(new ParentChildIntersectTermsEnum(reader, "_uid", "_parent"), parentTypes);
        ParentChildEstimator estimator = new ParentChildEstimator(this.breakerService.getBreaker("fielddata"), (TermsEnum)termsEnum);
        TermsEnum estimatedTermsEnum = estimator.beforeLoad(null);
        ObjectObjectHashMap typeBuilders = new ObjectObjectHashMap();
        try {
            try {
                PostingsEnum docsEnum = null;
                BytesRef term = estimatedTermsEnum.next();
                while (term != null) {
                    String type = termsEnum.type();
                    TypeBuilder typeBuilder = (TypeBuilder)typeBuilders.get((Object)type);
                    if (typeBuilder == null) {
                        typeBuilder = new TypeBuilder(acceptableTransientOverheadRatio, reader);
                        typeBuilders.put((Object)type, (Object)typeBuilder);
                    }
                    BytesRef id = termsEnum.id();
                    long termOrd = typeBuilder.builder.nextOrdinal();
                    assert (termOrd == typeBuilder.termOrdToBytesOffset.size());
                    typeBuilder.termOrdToBytesOffset.add(typeBuilder.bytes.copyUsingLengthPrefix(id));
                    docsEnum = estimatedTermsEnum.postings(docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        typeBuilder.builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = estimatedTermsEnum.next();
                }
                ImmutableOpenMap.Builder<Object, PagedBytesAtomicFieldData> typeToAtomicFieldData = ImmutableOpenMap.builder(typeBuilders.size());
                for (ObjectObjectCursor cursor : typeBuilders) {
                    PagedBytes.Reader bytesReader = ((TypeBuilder)cursor.value).bytes.freeze(true);
                    Ordinals ordinals = ((TypeBuilder)cursor.value).builder.build(this.fieldDataType.getSettings());
                    typeToAtomicFieldData.put(cursor.key, new PagedBytesAtomicFieldData(bytesReader, ((TypeBuilder)cursor.value).termOrdToBytesOffset.build(), ordinals));
                }
                data = new ParentChildAtomicFieldData(typeToAtomicFieldData.build());
            }
            catch (Throwable throwable) {
                for (ObjectObjectCursor cursor : typeBuilders) {
                    ((TypeBuilder)cursor.value).builder.close();
                }
                throw throwable;
            }
            for (ObjectObjectCursor cursor : typeBuilders) {
                ((TypeBuilder)cursor.value).builder.close();
            }
            success = true;
            ParentChildAtomicFieldData parentChildAtomicFieldData = data;
            return parentChildAtomicFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(estimatedTermsEnum, data.ramBytesUsed());
            } else {
                estimator.afterLoad(estimatedTermsEnum, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeCreate(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active() && this.parentTypes.add(parentFieldMapper.type())) {
                this.clear();
            }
        }
    }

    @Override
    protected AtomicParentChildFieldData empty(int maxDoc) {
        return new ParentChildAtomicFieldData(ImmutableOpenMap.of());
    }

    @Override
    public IndexParentChildFieldData loadGlobal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e, new Object[0]);
        }
    }

    private static MultiDocValues.OrdinalMap buildOrdinalMap(AtomicParentChildFieldData[] atomicFD, String parentType) throws IOException {
        SortedDocValues[] ordinals = new SortedDocValues[atomicFD.length];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = atomicFD[i].getOrdinalsValues(parentType);
        }
        return MultiDocValues.OrdinalMap.build(null, (SortedDocValues[])ordinals, (float)0.25f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexParentChildFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        ImmutableSet parentTypes;
        long startTime = System.nanoTime();
        if (Version.indexCreated(this.indexSettings()).before(Version.V_2_0_0_beta1)) {
            Object object = this.lock;
            synchronized (object) {
                parentTypes = ImmutableSet.copyOf(this.parentTypes);
            }
        } else {
            parentTypes = this.parentTypes;
        }
        long ramBytesUsed = 0L;
        HashMap<String, OrdinalMapAndAtomicFieldData> perType = new HashMap<String, OrdinalMapAndAtomicFieldData>();
        for (String type : parentTypes) {
            AtomicParentChildFieldData[] fieldData = new AtomicParentChildFieldData[indexReader.leaves().size()];
            for (LeafReaderContext context : indexReader.leaves()) {
                fieldData[context.ord] = this.load(context);
            }
            MultiDocValues.OrdinalMap ordMap = ParentChildIndexFieldData.buildOrdinalMap(fieldData, type);
            ramBytesUsed += ordMap.ramBytesUsed();
            perType.put(type, new OrdinalMapAndAtomicFieldData(ordMap, fieldData));
        }
        AtomicParentChildFieldData[] fielddata = new AtomicParentChildFieldData[indexReader.leaves().size()];
        for (int i = 0; i < fielddata.length; ++i) {
            fielddata[i] = new GlobalAtomicFieldData((Set<String>)parentTypes, perType, i);
        }
        this.breakerService.getBreaker("fielddata").addWithoutBreaking(ramBytesUsed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Global-ordinals[_parent] took {}", new TimeValue(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
        }
        return new GlobalFieldData((IndexReader)indexReader, fielddata, ramBytesUsed, perType);
    }

    public static MultiDocValues.OrdinalMap getOrdinalMap(IndexParentChildFieldData indexParentChildFieldData, String type) {
        if (indexParentChildFieldData instanceof GlobalFieldData) {
            return ((OrdinalMapAndAtomicFieldData)((GlobalFieldData)((GlobalFieldData)indexParentChildFieldData)).ordinalMapPerType.get((Object)type)).ordMap;
        }
        return null;
    }

    public class GlobalFieldData
    implements IndexParentChildFieldData,
    Accountable {
        private final AtomicParentChildFieldData[] fielddata;
        private final IndexReader reader;
        private final long ramBytesUsed;
        private final Map<String, OrdinalMapAndAtomicFieldData> ordinalMapPerType;

        GlobalFieldData(IndexReader reader, AtomicParentChildFieldData[] fielddata, long ramBytesUsed, Map<String, OrdinalMapAndAtomicFieldData> ordinalMapPerType) {
            this.reader = reader;
            this.ramBytesUsed = ramBytesUsed;
            this.fielddata = fielddata;
            this.ordinalMapPerType = ordinalMapPerType;
        }

        @Override
        public MappedFieldType.Names getFieldNames() {
            return ParentChildIndexFieldData.this.getFieldNames();
        }

        @Override
        public FieldDataType getFieldDataType() {
            return ParentChildIndexFieldData.this.getFieldDataType();
        }

        @Override
        public AtomicParentChildFieldData load(LeafReaderContext context) {
            assert (context.reader().getCoreCacheKey() == ((LeafReaderContext)this.reader.leaves().get(context.ord)).reader().getCoreCacheKey());
            return this.fielddata[context.ord];
        }

        @Override
        public AtomicParentChildFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
            throw new UnsupportedOperationException("No sorting on global ords");
        }

        @Override
        public void clear() {
            ParentChildIndexFieldData.this.clear();
        }

        @Override
        public Index index() {
            return ParentChildIndexFieldData.this.index();
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public IndexParentChildFieldData loadGlobal(DirectoryReader indexReader) {
            if (indexReader.getCoreCacheKey() == this.reader.getCoreCacheKey()) {
                return this;
            }
            throw new IllegalStateException();
        }

        @Override
        public IndexParentChildFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }
    }

    private static class GlobalAtomicFieldData
    extends AbstractAtomicParentChildFieldData {
        private final Set<String> types;
        private final Map<String, OrdinalMapAndAtomicFieldData> atomicFD;
        private final int segmentIndex;

        public GlobalAtomicFieldData(Set<String> types, Map<String, OrdinalMapAndAtomicFieldData> atomicFD, int segmentIndex) {
            this.types = types;
            this.atomicFD = atomicFD;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public Set<String> types() {
            return this.types;
        }

        @Override
        public SortedDocValues getOrdinalsValues(String type) {
            OrdinalMapAndAtomicFieldData atomicFD = this.atomicFD.get(type);
            if (atomicFD == null) {
                return DocValues.emptySorted();
            }
            final MultiDocValues.OrdinalMap ordMap = atomicFD.ordMap;
            final SortedDocValues[] allSegmentValues = new SortedDocValues[atomicFD.fieldData.length];
            for (int i = 0; i < allSegmentValues.length; ++i) {
                allSegmentValues[i] = atomicFD.fieldData[i].getOrdinalsValues(type);
            }
            final SortedDocValues segmentValues = allSegmentValues[this.segmentIndex];
            if ((long)segmentValues.getValueCount() == ordMap.getValueCount()) {
                return segmentValues;
            }
            final LongValues globalOrds = ordMap.getGlobalOrds(this.segmentIndex);
            return new SortedDocValues(){

                public BytesRef lookupOrd(int ord) {
                    int segmentIndex = ordMap.getFirstSegmentNumber((long)ord);
                    int segmentOrd = (int)ordMap.getFirstSegmentOrd((long)ord);
                    return allSegmentValues[segmentIndex].lookupOrd(segmentOrd);
                }

                public int getValueCount() {
                    return (int)ordMap.getValueCount();
                }

                public int getOrd(int docID) {
                    int segmentOrd = segmentValues.getOrd(docID);
                    if (segmentOrd >= 0) {
                        return (int)globalOrds.get(segmentOrd);
                    }
                    return segmentOrd;
                }
            };
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
            ArrayList<AtomicParentChildFieldData> closeables = new ArrayList<AtomicParentChildFieldData>();
            for (OrdinalMapAndAtomicFieldData fds : this.atomicFD.values()) {
                closeables.addAll(Arrays.asList(fds.fieldData));
            }
            Releasables.close(closeables);
        }
    }

    private static class OrdinalMapAndAtomicFieldData {
        final MultiDocValues.OrdinalMap ordMap;
        final AtomicParentChildFieldData[] fieldData;

        public OrdinalMapAndAtomicFieldData(MultiDocValues.OrdinalMap ordMap, AtomicParentChildFieldData[] fieldData) {
            this.ordMap = ordMap;
            this.fieldData = fieldData;
        }
    }

    public class ParentChildEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final CircuitBreaker breaker;
        private final TermsEnum filteredEnum;

        public ParentChildEstimator(CircuitBreaker breaker, TermsEnum filteredEnum) {
            this.breaker = breaker;
            this.filteredEnum = filteredEnum;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            return 2 * term.length;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.filteredEnum, this.breaker, this, "parent/child id cache");
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ParentChildIndexFieldData(index, indexSettings, fieldType.names(), fieldType.fieldDataType(), cache, mapperService, breakerService);
        }
    }

    class TypeBuilder {
        final PagedBytes bytes = new PagedBytes(15);
        final PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
        final OrdinalsBuilder builder;

        TypeBuilder(float acceptableTransientOverheadRatio, LeafReader reader) throws IOException {
            this.builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        }
    }
}

