/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.standard.std40.UAX29URLEmailTokenizer40;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class UAX29URLEmailTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    @Inject
    public UAX29URLEmailTokenizerFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", (Integer)255);
    }

    @Override
    public Tokenizer create() {
        if (this.version.onOrAfter(Version.LUCENE_4_7)) {
            UAX29URLEmailTokenizer tokenizer = new UAX29URLEmailTokenizer();
            tokenizer.setMaxTokenLength(this.maxTokenLength);
            return tokenizer;
        }
        UAX29URLEmailTokenizer40 tokenizer = new UAX29URLEmailTokenizer40();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

