/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.percolate.MultiPercolateRequest;
import org.elasticsearch.action.percolate.PercolateShardRequest;
import org.elasticsearch.action.percolate.PercolateShardResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.percolator.PercolatorService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiPercolateAction
extends TransportSingleShardAction<Request, Response> {
    private final PercolatorService percolatorService;
    private static final String ACTION_NAME = "indices:data/read/mpercolate[shard]";

    @Inject
    public TransportShardMultiPercolateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PercolatorService percolatorService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request.class, "percolate");
        this.percolatorService = percolatorService;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Response newResponse() {
        return new Response();
    }

    @Override
    protected boolean resolveIndex(Request request) {
        return false;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((Request)request.request()).shardId(), ((Request)request.request()).preference);
    }

    @Override
    protected Response shardOperation(Request request, ShardId shardId) {
        Response response = new Response();
        response.items = new ArrayList(request.items.size());
        for (Request.Item item : request.items) {
            Response.Item responseItem;
            int slot = item.slot;
            try {
                responseItem = new Response.Item((Integer)slot, this.percolatorService.percolate(item.request));
            }
            catch (Throwable t) {
                if (TransportActions.isShardNotAvailableException(t)) {
                    throw (ElasticsearchException)t;
                }
                this.logger.debug("{} failed to multi percolate", t, request.shardId());
                responseItem = new Response.Item((Integer)slot, t);
            }
            response.items.add(responseItem);
        }
        return response;
    }

    public static class Response
    extends ActionResponse {
        private List<Item> items;

        public List<Item> items() {
            return this.items;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.items.size());
            for (Item item : this.items) {
                out.writeVInt(item.slot);
                if (item.response != null) {
                    out.writeBoolean(true);
                    item.response.writeTo(out);
                    continue;
                }
                out.writeBoolean(false);
                out.writeThrowable(item.error);
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int size = in.readVInt();
            this.items = new ArrayList<Item>(size);
            for (int i = 0; i < size; ++i) {
                int slot = in.readVInt();
                if (in.readBoolean()) {
                    PercolateShardResponse shardResponse = new PercolateShardResponse();
                    shardResponse.readFrom(in);
                    this.items.add(new Item((Integer)slot, shardResponse));
                    continue;
                }
                this.items.add(new Item((Integer)slot, (Throwable)in.readThrowable()));
            }
        }

        public static class Item {
            private final int slot;
            private final PercolateShardResponse response;
            private final Throwable error;

            public Item(Integer slot, PercolateShardResponse response) {
                this.slot = slot;
                this.response = response;
                this.error = null;
            }

            public Item(Integer slot, Throwable error) {
                this.slot = slot;
                this.error = error;
                this.response = null;
            }

            public int slot() {
                return this.slot;
            }

            public PercolateShardResponse response() {
                return this.response;
            }

            public Throwable error() {
                return this.error;
            }

            public boolean failed() {
                return this.error != null;
            }
        }
    }

    public static class Request
    extends SingleShardRequest
    implements IndicesRequest {
        private int shardId;
        private String preference;
        private List<Item> items;

        public Request() {
        }

        Request(MultiPercolateRequest multiPercolateRequest, String concreteIndex, int shardId, String preference) {
            super(multiPercolateRequest, concreteIndex);
            this.shardId = shardId;
            this.preference = preference;
            this.items = new ArrayList<Item>();
        }

        @Override
        public ActionRequestValidationException validate() {
            return super.validateNonNullIndex();
        }

        @Override
        public String[] indices() {
            ArrayList indices = new ArrayList();
            for (Item item : this.items) {
                Collections.addAll(indices, item.request.indices());
            }
            return indices.toArray(new String[indices.size()]);
        }

        public int shardId() {
            return this.shardId;
        }

        public void add(Item item) {
            this.items.add(item);
        }

        public List<Item> items() {
            return this.items;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = in.readVInt();
            this.preference = in.readOptionalString();
            int size = in.readVInt();
            this.items = new ArrayList<Item>(size);
            for (int i = 0; i < size; ++i) {
                int slot = in.readVInt();
                OriginalIndices originalIndices = OriginalIndices.readOriginalIndices(in);
                PercolateShardRequest shardRequest = new PercolateShardRequest(new ShardId(this.index, this.shardId), originalIndices);
                shardRequest.documentType(in.readString());
                shardRequest.source(in.readBytesReference());
                shardRequest.docSource(in.readBytesReference());
                shardRequest.onlyCount(in.readBoolean());
                Item item = new Item(slot, shardRequest);
                this.items.add(item);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.shardId);
            out.writeOptionalString(this.preference);
            out.writeVInt(this.items.size());
            for (Item item : this.items) {
                out.writeVInt(item.slot);
                OriginalIndices.writeOriginalIndices(item.request.originalIndices(), out);
                out.writeString(item.request.documentType());
                out.writeBytesReference(item.request.source());
                out.writeBytesReference(item.request.docSource());
                out.writeBoolean(item.request.onlyCount());
            }
        }

        static class Item {
            private final int slot;
            private final PercolateShardRequest request;

            public Item(int slot, PercolateShardRequest request) {
                this.slot = slot;
                this.request = request;
            }

            public int slot() {
                return this.slot;
            }

            public PercolateShardRequest request() {
                return this.request;
            }
        }
    }
}

