/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.obs.IBitSet;

public class Murmur3BloomFilter
extends BloomFilter {
    public static final Murmur3BloomFilterSerializer serializer = new Murmur3BloomFilterSerializer();

    public Murmur3BloomFilter(int hashes, IBitSet bs) {
        super(hashes, bs);
    }

    @Override
    protected long[] hash(ByteBuffer b, int position, int remaining, long seed) {
        return MurmurHash.hash3_x64_128(b, b.position(), b.remaining(), seed);
    }

    public static class Murmur3BloomFilterSerializer
    extends BloomFilterSerializer {
        @Override
        protected BloomFilter createFilter(int hashes, IBitSet bs) {
            return new Murmur3BloomFilter(hashes, bs);
        }
    }
}

