/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcDecimal
extends AbstractJdbcType<BigDecimal> {
    public static final JdbcDecimal instance = new JdbcDecimal();

    JdbcDecimal() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(BigDecimal obj) {
        return obj.scale();
    }

    @Override
    public int getPrecision(BigDecimal obj) {
        return obj.precision();
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(BigDecimal obj) {
        return obj.toPlainString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.remaining() == 0) {
            return "empty";
        }
        return this.compose(bytes).toPlainString();
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public int getJdbcType() {
        return 3;
    }

    @Override
    public BigDecimal compose(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        bytes = bytes.duplicate();
        int scale = bytes.getInt();
        byte[] bibytes = new byte[bytes.remaining()];
        bytes.get(bibytes);
        BigInteger bi = new BigInteger(bibytes);
        return new BigDecimal(bi, scale);
    }

    @Override
    public ByteBuffer decompose(BigDecimal value) {
        int i;
        if (value == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        BigInteger bi = value.unscaledValue();
        Integer scale = value.scale();
        byte[] bibytes = bi.toByteArray();
        byte[] sbytes = ByteBufferUtil.bytes(scale).array();
        byte[] bytes = new byte[bi.toByteArray().length + 4];
        for (i = 0; i < 4; ++i) {
            bytes[i] = sbytes[i];
        }
        for (i = 4; i < bibytes.length + 4; ++i) {
            bytes[i] = bibytes[i - 4];
        }
        return ByteBuffer.wrap(bytes);
    }
}

