/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.cql.test.utils.AstyanaxContextFactory;
import com.netflix.astyanax.cql.test.utils.ClusterConfiguration;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchemaTests
extends KeyspaceTests {
    @BeforeClass
    public static void init() throws Exception {
        SchemaTests.initContext();
    }

    @Test
    public void createKeyspaceUsingOptions() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceUsingOptions".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForSimpleStrategy(keyspaceName, ksDef);
        keyspace.dropKeyspace();
        keyspaceName = "AstyanaxTestKeyspaceUsingOptions2".toLowerCase();
        context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"us-east", (Object)"3").put((Object)"eu-west", (Object)"3").build()).put((Object)"strategy_class", (Object)"NetworkTopologyStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForNetworkTopology(keyspaceName, ksDef);
        keyspace.dropKeyspace();
    }

    @Test
    public void createKeyspaceUsingProperties() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceUsingProperties".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        Properties props = new Properties();
        props.setProperty("strategy_options.replication_factor", "1");
        props.setProperty("strategy_class", "SimpleStrategy");
        keyspace.createKeyspace(props);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForSimpleStrategy(keyspaceName, ksDef);
        keyspace.dropKeyspace();
        keyspaceName = "AstyanaxTestKeyspaceUsingProperties2".toLowerCase();
        context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        props = new Properties();
        props.setProperty("strategy_options.us-east", "3");
        props.setProperty("strategy_options.eu-west", "3");
        props.setProperty("strategy_class", "NetworkTopologyStrategy");
        keyspace.createKeyspace(props);
        Thread.sleep(1000L);
        ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForNetworkTopology(keyspaceName, ksDef);
        keyspace.dropKeyspace();
    }

    private void verifyKeyspacePropertiesForSimpleStrategy(String keyspaceName, KeyspaceDefinition ksDef) throws Exception {
        Assert.assertEquals((String)keyspaceName, (String)ksDef.getName());
        Assert.assertTrue((boolean)ksDef.getStrategyClass().contains("SimpleStrategy"));
        Properties properties = ksDef.getProperties();
        Assert.assertEquals((String)keyspaceName, (String)properties.getProperty("name"));
        Assert.assertEquals((Object)"true", (Object)properties.get("durable_writes"));
        String strategyClass = properties.getProperty("strategy_class");
        if (strategyClass == null) {
            strategyClass = properties.getProperty("replication.class");
        }
        Assert.assertTrue((boolean)ksDef.getStrategyClass().contains("SimpleStrategy"));
        Map strategyOptions = ksDef.getStrategyOptions();
        Assert.assertEquals((String)"1", (String)((String)strategyOptions.get("replication_factor")));
    }

    private void verifyKeyspacePropertiesForNetworkTopology(String keyspaceName, KeyspaceDefinition ksDef) throws Exception {
        Assert.assertEquals((String)keyspaceName, (String)ksDef.getName());
        Assert.assertTrue((boolean)ksDef.getStrategyClass().contains("NetworkTopologyStrategy"));
        Properties properties = ksDef.getProperties();
        Assert.assertEquals((String)keyspaceName, (String)properties.getProperty("name"));
        Assert.assertEquals((Object)"true", (Object)properties.get("durable_writes"));
        String strategyClass = properties.getProperty("strategy_class");
        if (strategyClass == null) {
            strategyClass = properties.getProperty("replication.class");
        }
        Assert.assertTrue((boolean)ksDef.getStrategyClass().contains("NetworkTopologyStrategy"));
        Map strategyOptions = ksDef.getStrategyOptions();
        Assert.assertEquals((String)"3", (String)((String)strategyOptions.get("us-east")));
        Assert.assertEquals((String)"3", (String)((String)strategyOptions.get("eu-west")));
    }

    @Test
    public void createKeyspaceAndCFsUsingUsingOptions() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceAndCFsUsingOptions".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        ImmutableMap cfs = ImmutableMap.builder().put((Object)new ColumnFamily("testcf1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get()), (Object)ImmutableMap.builder().put((Object)"bloom_filter_fp_chance", (Object)0.01).build()).put((Object)new ColumnFamily("testcf2", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()), (Object)ImmutableMap.builder().put((Object)"read_repair_chance", (Object)0.2).put((Object)"bloom_filter_fp_chance", (Object)0.01).build()).build();
        keyspace.createKeyspace((Map)options, (Map)cfs);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForSimpleStrategy(keyspaceName, ksDef);
        Map strategyOptions = ksDef.getStrategyOptions();
        Assert.assertEquals((String)"1", (String)((String)strategyOptions.get("replication_factor")));
        Properties cfProps = keyspace.getColumnFamilyProperties("testcf1");
        Assert.assertEquals((String)"0.1", (String)String.valueOf(cfProps.get("read_repair_chance")));
        Assert.assertEquals((String)"0.01", (String)String.valueOf(cfProps.get("bloom_filter_fp_chance")));
        Assert.assertEquals((String)"KEYS_ONLY", (String)String.valueOf(cfProps.get("caching")));
        Assert.assertEquals((String)"4", (String)String.valueOf(cfProps.get("min_compaction_threshold")));
        Assert.assertEquals((String)"32", (String)String.valueOf(cfProps.get("max_compaction_threshold")));
        cfProps = keyspace.getColumnFamilyProperties("testcf2");
        Assert.assertEquals((String)"0.2", (String)String.valueOf(cfProps.get("read_repair_chance")));
        Assert.assertEquals((String)"0.01", (String)String.valueOf(cfProps.get("bloom_filter_fp_chance")));
        Assert.assertEquals((String)"KEYS_ONLY", (String)String.valueOf(cfProps.get("caching")));
        Assert.assertEquals((String)"4", (String)String.valueOf(cfProps.get("min_compaction_threshold")));
        Assert.assertEquals((String)"32", (String)String.valueOf(cfProps.get("max_compaction_threshold")));
        keyspace.dropKeyspace();
    }

    @Test
    public void createKeyspaceAndCFsDirectly() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceAndCFsDirect".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap ksOptions = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)ksOptions);
        ColumnFamily cf1 = new ColumnFamily("testcf1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        ImmutableMap options1 = ImmutableMap.builder().put((Object)"read_repair_chance", (Object)0.2).put((Object)"bloom_filter_fp_chance", (Object)0.01).build();
        keyspace.createColumnFamily(cf1, (Map)options1);
        HashMap<String, Object> options2 = new HashMap<String, Object>();
        options2.put("name", "testcf2");
        options2.put("read_repair_chance", 0.4);
        options2.put("bloom_filter_fp_chance", 0.01);
        keyspace.createColumnFamily(options2);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForSimpleStrategy(keyspaceName, ksDef);
        Properties cfProps = keyspace.getColumnFamilyProperties("testcf1");
        Assert.assertEquals((String)"0.2", (String)String.valueOf(cfProps.get("read_repair_chance")));
        Assert.assertEquals((String)"0.01", (String)String.valueOf(cfProps.get("bloom_filter_fp_chance")));
        Assert.assertEquals((String)"KEYS_ONLY", (String)String.valueOf(cfProps.get("caching")));
        Assert.assertEquals((String)"4", (String)String.valueOf(cfProps.get("min_compaction_threshold")));
        Assert.assertEquals((String)"32", (String)String.valueOf(cfProps.get("max_compaction_threshold")));
        cfProps = keyspace.getColumnFamilyProperties("testcf2");
        Assert.assertEquals((String)"0.4", (String)String.valueOf(cfProps.get("read_repair_chance")));
        Assert.assertEquals((String)"0.01", (String)String.valueOf(cfProps.get("bloom_filter_fp_chance")));
        Assert.assertEquals((String)"KEYS_ONLY", (String)String.valueOf(cfProps.get("caching")));
        Assert.assertEquals((String)"4", (String)String.valueOf(cfProps.get("min_compaction_threshold")));
        Assert.assertEquals((String)"32", (String)String.valueOf(cfProps.get("max_compaction_threshold")));
        ColumnFamilyDefinition cfDef = ksDef.getColumnFamily("testcf1");
        Assert.assertEquals((String)"testcf1", (String)cfDef.getName());
        Assert.assertEquals((Object)0.2, (Object)cfDef.getReadRepairChance());
        Assert.assertEquals((String)"KEYS_ONLY", (String)cfDef.getCaching());
        Assert.assertTrue((32 == cfDef.getMaxCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertTrue((4 == cfDef.getMinCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertEquals((Object)0.01, (Object)cfDef.getBloomFilterFpChance());
        cfDef = ksDef.getColumnFamily("testcf2");
        Assert.assertEquals((String)"testcf2", (String)cfDef.getName());
        Assert.assertEquals((Object)0.4, (Object)cfDef.getReadRepairChance());
        Assert.assertEquals((String)"KEYS_ONLY", (String)cfDef.getCaching());
        Assert.assertTrue((32 == cfDef.getMaxCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertTrue((4 == cfDef.getMinCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertEquals((Object)0.01, (Object)cfDef.getBloomFilterFpChance());
        List cfDefs = ksDef.getColumnFamilyList();
        Assert.assertTrue((2 == cfDefs.size() ? 1 : 0) != 0);
        cfDef = (ColumnFamilyDefinition)cfDefs.get(0);
        Assert.assertEquals((String)"testcf1", (String)cfDef.getName());
        Assert.assertEquals((Object)0.2, (Object)cfDef.getReadRepairChance());
        Assert.assertEquals((String)"KEYS_ONLY", (String)cfDef.getCaching());
        Assert.assertTrue((32 == cfDef.getMaxCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertTrue((4 == cfDef.getMinCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertEquals((Object)0.01, (Object)cfDef.getBloomFilterFpChance());
        cfDef = (ColumnFamilyDefinition)cfDefs.get(1);
        Assert.assertEquals((String)"testcf2", (String)cfDef.getName());
        Assert.assertEquals((Object)0.4, (Object)cfDef.getReadRepairChance());
        Assert.assertEquals((String)"KEYS_ONLY", (String)cfDef.getCaching());
        Assert.assertTrue((32 == cfDef.getMaxCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertTrue((4 == cfDef.getMinCompactionThreshold() ? 1 : 0) != 0);
        Assert.assertEquals((Object)0.01, (Object)cfDef.getBloomFilterFpChance());
        keyspace.dropKeyspace();
    }

    @Test
    public void createKeyspaceWithCompositeCF() throws Exception {
        class Population {
            @Component(ordinal=0)
            String country;
            @Component(ordinal=1)
            String state;
            @Component(ordinal=2)
            String city;
            @Component(ordinal=3)
            Integer zip;
            @Component(ordinal=3)
            Date district;
        }
        AnnotatedCompositeSerializer compSerializer = new AnnotatedCompositeSerializer(Population.class);
        ColumnFamily CF_POPULATION = new ColumnFamily("population", (Serializer)StringSerializer.get(), (Serializer)compSerializer);
        String keyspaceName = "AstyanaxTestKeyspaceCompositeCFs".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap ksOptions = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)ksOptions);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        Assert.assertEquals((String)keyspaceName, (String)ksDef.getName());
        keyspace.createColumnFamily(CF_POPULATION, (Map)ImmutableMap.builder().put((Object)"default_validation_class", (Object)"UTF8Type").put((Object)"key_validation_class", (Object)"UTF8Type").put((Object)"comparator_type", (Object)"CompositeType(UTF8Type, UTF8Type, UTF8Type, Int32Type, DateType)").build());
        if (ClusterConfiguration.getDriver().equals((Object)ClusterConfiguration.Driver.JAVA_DRIVER)) {
            List list = ksDef.getColumnFamilyList();
            Assert.assertTrue((1 == list.size() ? 1 : 0) != 0);
            ColumnFamilyDefinition cfDef = (ColumnFamilyDefinition)list.get(0);
            Assert.assertEquals((String)"population", (String)cfDef.getName());
            List colDefs = cfDef.getColumnDefinitionList();
            Assert.assertTrue((7 == colDefs.size() ? 1 : 0) != 0);
            for (int i = 1; i <= 5; ++i) {
                ColumnDefinition colDef = (ColumnDefinition)colDefs.get(i - 1);
                Assert.assertEquals((String)("column" + i), (String)colDef.getName());
                Assert.assertNotNull((Object)colDef.getValidationClass());
            }
            ColumnDefinition colDef = (ColumnDefinition)colDefs.get(6);
            Assert.assertEquals((String)"value", (String)colDef.getName());
            Assert.assertNotNull((Object)colDef.getValidationClass());
            cfDef = ksDef.getColumnFamily("population");
            Assert.assertEquals((String)"population", (String)cfDef.getName());
            colDefs = cfDef.getColumnDefinitionList();
            Assert.assertTrue((7 == colDefs.size() ? 1 : 0) != 0);
            for (int i = 1; i <= 5; ++i) {
                colDef = (ColumnDefinition)colDefs.get(i - 1);
                Assert.assertEquals((String)("column" + i), (String)colDef.getName());
                Assert.assertNotNull((Object)colDef.getValidationClass());
            }
            colDef = (ColumnDefinition)colDefs.get(6);
            Assert.assertEquals((String)"value", (String)colDef.getName());
            Assert.assertNotNull((Object)colDef.getValidationClass());
        }
        keyspace.dropKeyspace();
    }

    @Test
    public void alterKeyspaceOptions() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceAlterOptions".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForSimpleStrategy(keyspaceName, ksDef);
        keyspace.updateKeyspace((Map)ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"2").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build());
        ksDef = keyspace.describeKeyspace();
        Assert.assertEquals((String)"2", (String)((String)ksDef.getStrategyOptions().get("replication_factor")));
        keyspace.dropKeyspace();
        keyspaceName = "AstyanaxTestKeyspaceAlterOptions2".toLowerCase();
        context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"us-east", (Object)"3").put((Object)"eu-west", (Object)"3").build()).put((Object)"strategy_class", (Object)"NetworkTopologyStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef2 = keyspace.describeKeyspace();
        this.verifyKeyspacePropertiesForNetworkTopology(keyspaceName, ksDef2);
        options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"us-east", (Object)"2").put((Object)"eu-west", (Object)"2").build()).put((Object)"strategy_class", (Object)"NetworkTopologyStrategy").build();
        keyspace.updateKeyspace((Map)options);
        ksDef2 = keyspace.describeKeyspace();
        System.out.println(ksDef2.getStrategyOptions());
        Assert.assertEquals((String)"2", (String)((String)ksDef2.getStrategyOptions().get("us-east")));
        Assert.assertEquals((String)"2", (String)((String)ksDef2.getStrategyOptions().get("eu-west")));
        keyspace.dropKeyspace();
    }

    @Test
    public void alterCFOptions() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceAlterCFOptions".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        ColumnFamily cf = new ColumnFamily("testaltercf1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        keyspace.createColumnFamily(cf, null);
        Assert.assertEquals((Object)0.1, (Object)keyspace.getColumnFamilyProperties("testaltercf1").get("read_repair_chance"));
        keyspace.updateColumnFamily(cf, (Map)ImmutableMap.builder().put((Object)"read_repair_chance", (Object)0.2).build());
        Assert.assertEquals((Object)0.2, (Object)keyspace.getColumnFamilyProperties("testaltercf1").get("read_repair_chance"));
        keyspace.dropKeyspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAndDeleteCF() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceCreateDeleteCF".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        ColumnFamily cf = new ColumnFamily("testcreatedeletecf1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        keyspace.createColumnFamily(cf, null);
        Assert.assertEquals((Object)0.1, (Object)keyspace.getColumnFamilyProperties("testcreatedeletecf1").get("read_repair_chance"));
        keyspace.dropColumnFamily(cf);
        try {
            keyspace.getColumnFamilyProperties("testaltercf1");
            Assert.fail((String)"Should have gotten CF not found ex");
        }
        catch (RuntimeException e) {
        }
        finally {
            keyspace.dropKeyspace();
        }
    }

    @Test
    public void createAndDeleteKeyspace() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceCreateDeleteKS".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        Assert.assertTrue((boolean)ksDef.getStrategyClass().contains("SimpleStrategy"));
        keyspace.dropKeyspace();
        try {
            keyspace.describeKeyspace();
            Assert.fail((String)"Should have gotten KS not found ex");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void keyspaceDescribePartitioner() throws Exception {
        String keyspaceName = "AstyanaxTestKeyspaceDescribeRing".toLowerCase();
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace(keyspaceName);
        context.start();
        keyspace = (Keyspace)context.getClient();
        ImmutableMap options = ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build();
        keyspace.createKeyspace((Map)options);
        Thread.sleep(1000L);
        String partitioner = keyspace.describePartitioner();
        Assert.assertNotNull((Object)partitioner);
        keyspace.dropKeyspace();
    }
}

