/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.cql.test.MockCompositeTypeTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.Map;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompositeKeyTests
extends KeyspaceTests {
    private static final Logger LOG = Logger.getLogger(CompositeKeyTests.class);
    private static AnnotatedCompositeSerializer<MockCompositeTypeTests.MockCompositeType> M_SERIALIZER = new AnnotatedCompositeSerializer(MockCompositeTypeTests.MockCompositeType.class);
    private static ColumnFamily<MockCompositeTypeTests.MockCompositeType, String> CF_COMPOSITE_KEY = ColumnFamily.newColumnFamily((String)"compositekey", M_SERIALIZER, (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        CompositeKeyTests.initContext();
        keyspace.createColumnFamily(CF_COMPOSITE_KEY, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)"BytesType").build());
        CF_COMPOSITE_KEY.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COMPOSITE_KEY);
    }

    @Test
    public void testCompositeKey() {
        MockCompositeTypeTests.MockCompositeType key = new MockCompositeTypeTests.MockCompositeType("A", 1, 2, true, "B");
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_COMPOSITE_KEY, (Object)key).putColumn((Object)"Test", "Value", null);
        try {
            m.execute();
        }
        catch (ConnectionException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail();
        }
        try {
            ColumnList row = (ColumnList)keyspace.prepareQuery(CF_COMPOSITE_KEY).getKey((Object)key).execute().getResult();
            Assert.assertFalse((boolean)row.isEmpty());
        }
        catch (ConnectionException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail();
        }
    }
}

