/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Comparator;

public class NumericalStringComparator
implements Comparator<String>,
Serializable {
    private boolean _ascending;
    private boolean _caseSensitive;

    public NumericalStringComparator() {
        this(true, false);
    }

    public NumericalStringComparator(boolean ascending, boolean caseSensitive) {
        this._ascending = ascending;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        int startsWithWeight = StringUtil.startsWithWeight(s1, s2);
        boolean lastMatchingCharIsDigit = false;
        if (startsWithWeight > 0 && Validator.isDigit(s1.charAt(startsWithWeight - 1))) {
            lastMatchingCharIsDigit = true;
        }
        s1 = s1.substring(startsWithWeight);
        s2 = s2.substring(startsWithWeight);
        String leadingDigits1 = StringUtil.extractLeadingDigits(s1);
        String leadingDigits2 = StringUtil.extractLeadingDigits(s2);
        int value = 0;
        if (lastMatchingCharIsDigit && (Validator.isNotNull(leadingDigits1) || Validator.isNotNull(leadingDigits2)) || Validator.isNotNull(leadingDigits1) && Validator.isNotNull(leadingDigits2)) {
            if (leadingDigits1.length() != leadingDigits2.length()) {
                value = leadingDigits1.length() - leadingDigits2.length();
            } else {
                int i1 = GetterUtil.getInteger(leadingDigits1);
                int i2 = GetterUtil.getInteger(leadingDigits2);
                value = i1 - i2;
            }
        } else {
            value = this._caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }
}

