/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;

public class QuerySearchResult
extends QuerySearchResultProvider {
    private long id;
    private SearchShardTarget shardTarget;
    private int from;
    private int size;
    private TopDocs topDocs;
    private InternalAggregations aggregations;
    private List<SiblingPipelineAggregator> pipelineAggregators;
    private Suggest suggest;
    private boolean searchTimedOut;
    private Boolean terminatedEarly = null;
    private List<ProfileShardResult> profileShardResults;

    public QuerySearchResult() {
    }

    public QuerySearchResult(long id, SearchShardTarget shardTarget) {
        this.id = id;
        this.shardTarget = shardTarget;
    }

    @Override
    public boolean includeFetch() {
        return false;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void terminatedEarly(boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public TopDocs topDocs() {
        return this.topDocs;
    }

    public void topDocs(TopDocs topDocs) {
        this.topDocs = topDocs;
    }

    public Aggregations aggregations() {
        return this.aggregations;
    }

    public void aggregations(InternalAggregations aggregations) {
        this.aggregations = aggregations;
    }

    @Nullable
    public List<ProfileShardResult> profileResults() {
        return this.profileShardResults;
    }

    public void profileResults(List<ProfileShardResult> shardResults) {
        this.profileShardResults = shardResults;
    }

    public List<SiblingPipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    public void pipelineAggregators(List<SiblingPipelineAggregator> pipelineAggregators) {
        this.pipelineAggregators = pipelineAggregators;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public static QuerySearchResult readQuerySearchResult(StreamInput in) throws IOException {
        QuerySearchResult result = new QuerySearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        long id = in.readLong();
        this.readFromWithId(id, in);
    }

    public void readFromWithId(long id, StreamInput in) throws IOException {
        this.id = id;
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        if (in.readBoolean()) {
            this.aggregations = InternalAggregations.readAggregations(in);
        }
        if (in.readBoolean()) {
            int size = in.readVInt();
            ArrayList<SiblingPipelineAggregator> pipelineAggregators = new ArrayList<SiblingPipelineAggregator>(size);
            for (int i = 0; i < size; ++i) {
                BytesReference type = in.readBytesReference();
                PipelineAggregator pipelineAggregator = PipelineAggregatorStreams.stream(type).readResult(in);
                pipelineAggregators.add((SiblingPipelineAggregator)pipelineAggregator);
            }
            this.pipelineAggregators = pipelineAggregators;
        }
        if (in.readBoolean()) {
            this.suggest = Suggest.readSuggest(Suggest.Fields.SUGGEST, in);
        }
        this.searchTimedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_2_0) && in.readBoolean()) {
            int profileSize = in.readVInt();
            this.profileShardResults = new ArrayList<ProfileShardResult>(profileSize);
            for (int i = 0; i < profileSize; ++i) {
                ProfileShardResult result = new ProfileShardResult(in);
                this.profileShardResults.add(result);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.writeToNoId(out);
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        if (this.pipelineAggregators == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.pipelineAggregators.size());
            for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
                out.writeBytesReference(pipelineAggregator.type().stream());
                pipelineAggregator.writeTo(out);
            }
        }
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            if (this.profileShardResults == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeVInt(this.profileShardResults.size());
                for (ProfileShardResult profileShardResult : this.profileShardResults) {
                    profileShardResult.writeTo(out);
                }
            }
        }
    }
}

