/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class ExtendedStatsAggregator
extends NumericMetricsAggregator.MultiValue {
    final ValuesSource.Numeric valuesSource;
    final ValueFormatter formatter;
    final double sigma;
    LongArray counts;
    DoubleArray sums;
    DoubleArray mins;
    DoubleArray maxes;
    DoubleArray sumOfSqrs;

    public ExtendedStatsAggregator(String name, ValuesSource.Numeric valuesSource, ValueFormatter formatter, AggregationContext context, Aggregator parent, double sigma, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.sigma = sigma;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.mins = bigArrays.newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = bigArrays.newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
            this.sumOfSqrs = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= ExtendedStatsAggregator.this.counts.size()) {
                    long from = ExtendedStatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    ExtendedStatsAggregator.this.counts = bigArrays.resize(ExtendedStatsAggregator.this.counts, overSize);
                    ExtendedStatsAggregator.this.sums = bigArrays.resize(ExtendedStatsAggregator.this.sums, overSize);
                    ExtendedStatsAggregator.this.mins = bigArrays.resize(ExtendedStatsAggregator.this.mins, overSize);
                    ExtendedStatsAggregator.this.maxes = bigArrays.resize(ExtendedStatsAggregator.this.maxes, overSize);
                    ExtendedStatsAggregator.this.sumOfSqrs = bigArrays.resize(ExtendedStatsAggregator.this.sumOfSqrs, overSize);
                    ExtendedStatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    ExtendedStatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                values.setDocument(doc);
                int valuesCount = values.count();
                ExtendedStatsAggregator.this.counts.increment(bucket, valuesCount);
                double sum = 0.0;
                double sumOfSqr = 0.0;
                double min = ExtendedStatsAggregator.this.mins.get(bucket);
                double max = ExtendedStatsAggregator.this.maxes.get(bucket);
                for (int i = 0; i < valuesCount; ++i) {
                    double value = values.valueAt(i);
                    sum += value;
                    sumOfSqr += value * value;
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
                ExtendedStatsAggregator.this.sums.increment(bucket, sum);
                ExtendedStatsAggregator.this.sumOfSqrs.increment(bucket, sumOfSqr);
                ExtendedStatsAggregator.this.mins.set(bucket, min);
                ExtendedStatsAggregator.this.maxes.set(bucket, max);
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalExtendedStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        switch (InternalExtendedStats.Metrics.resolve(name)) {
            case count: {
                return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.valuesSource == null ? 0.0 : this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.valuesSource == null ? Double.POSITIVE_INFINITY : this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.valuesSource == null ? Double.NEGATIVE_INFINITY : this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
            case sum_of_squares: {
                return this.valuesSource == null ? 0.0 : this.sumOfSqrs.get(owningBucketOrd);
            }
            case variance: {
                return this.valuesSource == null ? Double.NaN : this.variance(owningBucketOrd);
            }
            case std_deviation: {
                return this.valuesSource == null ? Double.NaN : Math.sqrt(this.variance(owningBucketOrd));
            }
            case std_upper: {
                if (this.valuesSource == null) {
                    return Double.NaN;
                }
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) + Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
            case std_lower: {
                if (this.valuesSource == null) {
                    return Double.NaN;
                }
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) - Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    private double variance(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        return (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, 0.0, this.formatter, this.pipelineAggregators(), this.metaData());
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalExtendedStats(this.name, this.counts.get(owningBucketOrdinal), this.sums.get(owningBucketOrdinal), this.mins.get(owningBucketOrdinal), this.maxes.get(owningBucketOrdinal), this.sumOfSqrs.get(owningBucketOrdinal), this.sigma, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, 0.0, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sumOfSqrs, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        private final double sigma;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double sigma) {
            super(name, InternalExtendedStats.TYPE.name(), valuesSourceConfig);
            this.sigma = sigma;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new ExtendedStatsAggregator(this.name, null, this.config.formatter(), aggregationContext, parent, this.sigma, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new ExtendedStatsAggregator(this.name, valuesSource, this.config.formatter(), aggregationContext, parent, this.sigma, pipelineAggregators, metaData);
        }
    }
}

