/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.HDRPercentileRanksAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestPercentileRanksAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class PercentileRanksParser
extends AbstractPercentilesParser {
    public static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);

    public PercentileRanksParser() {
        super(false);
    }

    @Override
    public String type() {
        return InternalTDigestPercentileRanks.TYPE.name();
    }

    @Override
    protected ParseField keysField() {
        return VALUES_FIELD;
    }

    @Override
    protected AggregatorFactory buildFactory(SearchContext context, String aggregationName, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] keys, PercentilesMethod method, Double compression, Integer numberOfSignificantValueDigits, boolean keyed) {
        if (keys == null) {
            throw new SearchParseException(context, "Missing token values in [" + aggregationName + "].", null);
        }
        if (method == PercentilesMethod.TDIGEST) {
            return new TDigestPercentileRanksAggregator.Factory(aggregationName, valuesSourceConfig, keys, compression, keyed);
        }
        if (method == PercentilesMethod.HDR) {
            return new HDRPercentileRanksAggregator.Factory(aggregationName, valuesSourceConfig, keys, numberOfSignificantValueDigits, keyed);
        }
        throw new AssertionError();
    }
}

