/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.threadpool.ThreadPool;

public class RecoveriesCollection {
    private final ConcurrentMap<Long, RecoveryStatus> onGoingRecoveries = ConcurrentCollections.newConcurrentMap();
    private final ESLogger logger;
    private final ThreadPool threadPool;

    public RecoveriesCollection(ESLogger logger, ThreadPool threadPool) {
        this.logger = logger;
        this.threadPool = threadPool;
    }

    public long startRecovery(IndexShard indexShard, DiscoveryNode sourceNode, RecoveryTarget.RecoveryListener listener, TimeValue activityTimeout) {
        RecoveryStatus status = new RecoveryStatus(indexShard, sourceNode, listener);
        RecoveryStatus existingStatus = this.onGoingRecoveries.putIfAbsent(status.recoveryId(), status);
        assert (existingStatus == null) : "found two RecoveryStatus instances with the same id";
        this.logger.trace("{} started recovery from {}, id [{}]", indexShard.shardId(), sourceNode, status.recoveryId());
        this.threadPool.schedule(activityTimeout, "generic", new RecoveryMonitor(status.recoveryId(), status.lastAccessTime(), activityTimeout));
        return status.recoveryId();
    }

    public StatusRef getStatus(long id) {
        RecoveryStatus status = (RecoveryStatus)this.onGoingRecoveries.get(id);
        if (status != null && status.tryIncRef()) {
            return new StatusRef(status);
        }
        return null;
    }

    public StatusRef getStatusSafe(long id, ShardId shardId) {
        StatusRef statusRef = this.getStatus(id);
        if (statusRef == null) {
            throw new IndexShardClosedException(shardId);
        }
        assert (statusRef.status().shardId().equals(shardId));
        return statusRef;
    }

    public boolean cancelRecovery(long id, String reason) {
        RecoveryStatus removed = (RecoveryStatus)this.onGoingRecoveries.remove(id);
        boolean cancelled = false;
        if (removed != null) {
            this.logger.trace("{} canceled recovery from {}, id [{}] (reason [{}])", removed.shardId(), removed.sourceNode(), removed.recoveryId(), reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    public void failRecovery(long id, RecoveryFailedException e, boolean sendShardFailure) {
        RecoveryStatus removed = (RecoveryStatus)this.onGoingRecoveries.remove(id);
        if (removed != null) {
            this.logger.trace("{} failing recovery from {}, id [{}]. Send shard failure: [{}]", removed.shardId(), removed.sourceNode(), removed.recoveryId(), sendShardFailure);
            removed.fail(e, sendShardFailure);
        }
    }

    public void markRecoveryAsDone(long id) {
        RecoveryStatus removed = (RecoveryStatus)this.onGoingRecoveries.remove(id);
        if (removed != null) {
            this.logger.trace("{} marking recovery from {} as done, id [{}]", removed.shardId(), removed.sourceNode(), removed.recoveryId());
            removed.markAsDone();
        }
    }

    public int size() {
        return this.onGoingRecoveries.size();
    }

    public boolean cancelRecoveriesForShard(ShardId shardId, String reason) {
        return this.cancelRecoveriesForShard(shardId, reason, (Predicate<RecoveryStatus>)Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRecoveriesForShard(ShardId shardId, String reason, Predicate<RecoveryStatus> shouldCancel) {
        boolean cancelled = false;
        for (RecoveryStatus status : this.onGoingRecoveries.values()) {
            if (!status.shardId().equals(shardId)) continue;
            boolean cancel = false;
            if (status.tryIncRef()) {
                try {
                    cancel = shouldCancel.apply((Object)status);
                }
                finally {
                    status.decRef();
                }
            }
            if (!cancel || !this.cancelRecovery(status.recoveryId(), reason)) continue;
            cancelled = true;
        }
        return cancelled;
    }

    private class RecoveryMonitor
    extends AbstractRunnable {
        private final long recoveryId;
        private final TimeValue checkInterval;
        private long lastSeenAccessTime;

        private RecoveryMonitor(long recoveryId, long lastSeenAccessTime, TimeValue checkInterval) {
            this.recoveryId = recoveryId;
            this.checkInterval = checkInterval;
            this.lastSeenAccessTime = lastSeenAccessTime;
        }

        @Override
        public void onFailure(Throwable t) {
            RecoveriesCollection.this.logger.error("unexpected error while monitoring recovery [{}]", t, this.recoveryId);
        }

        @Override
        protected void doRun() throws Exception {
            RecoveryStatus status = (RecoveryStatus)RecoveriesCollection.this.onGoingRecoveries.get(this.recoveryId);
            if (status == null) {
                RecoveriesCollection.this.logger.trace("[monitor] no status found for [{}], shutting down", this.recoveryId);
                return;
            }
            long accessTime = status.lastAccessTime();
            if (accessTime == this.lastSeenAccessTime) {
                String message = "no activity after [" + this.checkInterval + "]";
                RecoveriesCollection.this.failRecovery(this.recoveryId, new RecoveryFailedException(status.state(), message, (Throwable)new ElasticsearchTimeoutException(message, new Object[0])), true);
                return;
            }
            this.lastSeenAccessTime = accessTime;
            RecoveriesCollection.this.logger.trace("[monitor] rescheduling check for [{}]. last access time is [{}]", this.lastSeenAccessTime);
            RecoveriesCollection.this.threadPool.schedule(this.checkInterval, "generic", this);
        }
    }

    public static class StatusRef
    implements AutoCloseable {
        private final RecoveryStatus status;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public StatusRef(RecoveryStatus status) {
            this.status = status;
            this.status.setLastAccessTime();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.status.decRef();
            }
        }

        public RecoveryStatus status() {
            return this.status;
        }
    }
}

