/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.schema;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.reads.CFRowQueryGen;
import com.netflix.astyanax.cql.schema.CqlColumnDefinitionImpl;
import com.netflix.astyanax.cql.util.DataTypeMapping;
import com.netflix.astyanax.cql.writes.CFMutationQueryGen;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CqlColumnFamilyDefinitionImpl
implements ColumnFamilyDefinition {
    private Session session;
    private String cfName;
    private String keyspaceName;
    private Map<String, Object> optionsMap = new HashMap<String, Object>();
    private List<ColumnDefinition> partitionKeyList = new ArrayList<ColumnDefinition>();
    private List<ColumnDefinition> clusteringKeyList = new ArrayList<ColumnDefinition>();
    private List<ColumnDefinition> regularColumnList = new ArrayList<ColumnDefinition>();
    private List<ColumnDefinition> allColumnsDefinitionList = new ArrayList<ColumnDefinition>();
    private String[] allPkColNames;
    private AnnotatedCompositeSerializer<?> compositeSerializer = null;
    private boolean alterTable = false;
    private CFMutationQueryGen mutationQueryGen = null;
    private CFRowQueryGen rowQueryGen = null;

    public CqlColumnFamilyDefinitionImpl(Session session) {
        this.session = session;
    }

    public CqlColumnFamilyDefinitionImpl(Session session, String keyspace, Properties props) {
        this(session, keyspace, CqlColumnFamilyDefinitionImpl.propertiesToMap(props));
    }

    public CqlColumnFamilyDefinitionImpl(Session session, String keyspace, Map<String, Object> options) {
        this.session = session;
        this.keyspaceName = keyspace;
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        this.initFromMap(options);
    }

    public CqlColumnFamilyDefinitionImpl(Session session, Row row) {
        this.initFromResultSet(session, row);
        this.mutationQueryGen = new CFMutationQueryGen(session, this.keyspaceName, this);
        this.rowQueryGen = new CFRowQueryGen(session, this.keyspaceName, this);
    }

    public CqlColumnFamilyDefinitionImpl(Session session, String keyspace, ColumnFamily<?, ?> columnFamily, Map<String, Object> options) {
        this.session = session;
        Preconditions.checkArgument((columnFamily != null ? 1 : 0) != 0, (Object)"ColumnFamily cannot be null");
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        this.keyspaceName = keyspace;
        this.cfName = columnFamily.getName();
        this.optionsMap.put("key_validator", columnFamily.getKeySerializer().getComparatorType().getClassName());
        this.optionsMap.put("comparator", columnFamily.getColumnSerializer().getComparatorType().getClassName());
        this.optionsMap.put("default_validator", columnFamily.getDefaultValueSerializer().getComparatorType().getClassName());
        if (columnFamily.getColumnSerializer() instanceof AnnotatedCompositeSerializer) {
            this.compositeSerializer = (AnnotatedCompositeSerializer)columnFamily.getColumnSerializer();
        }
        this.initFromMap(options);
    }

    private void initFromMap(Map<String, Object> options) {
        String kName;
        String cName = (String)options.get("name");
        if (cName != null) {
            this.cfName = cName;
            options.remove("name");
        }
        if ((kName = (String)options.get("keyspace")) != null) {
            this.keyspaceName = kName;
        }
        this.optionsMap.putAll(options);
        if (this.optionsMap.containsKey("key_validation_class")) {
            this.optionsMap.put("key_validator", this.optionsMap.remove("key_validation_class"));
        }
        if (this.optionsMap.containsKey("comparator_type")) {
            this.optionsMap.put("comparator", this.optionsMap.remove("comparator_type"));
        }
        if (this.optionsMap.containsKey("default_validation_class")) {
            this.optionsMap.put("default_validator", this.optionsMap.remove("default_validation_class"));
        }
    }

    private void initFromResultSet(Session session, Row row) {
        if (row == null) {
            throw new RuntimeException("Result Set is empty");
        }
        this.session = session;
        this.keyspaceName = row.getString("keyspace_name");
        this.cfName = row.getString("columnfamily_name");
        List colDefs = row.getColumnDefinitions().asList();
        for (ColumnDefinitions.Definition colDef : colDefs) {
            String colName = colDef.getName();
            DataType dataType = colDef.getType();
            Object value = DataTypeMapping.getDynamicColumn(row, colName, dataType);
            this.optionsMap.put(colName, value);
        }
        this.readColDefinitions();
    }

    private void processCompositeComparator() {
        int colIndex = 1;
        for (AnnotatedCompositeSerializer.ComponentSerializer componentSerializer : this.compositeSerializer.getComponents()) {
            String typeName = componentSerializer.getSerializer().getComparatorType().getTypeName();
            ColumnDefinition column = new CqlColumnDefinitionImpl().setName("column" + colIndex++).setValidationClass(typeName);
            this.clusteringKeyList.add(column);
        }
    }

    private void processCompositeComparatorSpec(String comparatorSpec) {
        String regex = "[\\(,\\)]";
        Pattern pattern = Pattern.compile(regex);
        String[] parts = pattern.split(comparatorSpec);
        int colIndex = 1;
        for (int i = 1; i < parts.length; ++i) {
            String componentTypeString = parts[i].trim();
            ColumnDefinition column = new CqlColumnDefinitionImpl().setName("column" + colIndex++).setValidationClass(componentTypeString);
            this.clusteringKeyList.add(column);
        }
    }

    private void createColumnDefinitions() {
        String keyClass = (String)this.optionsMap.remove("key_validator");
        String defaultBytesType = ComparatorType.BYTESTYPE.getTypeName();
        keyClass = keyClass == null ? (keyClass = defaultBytesType) : keyClass;
        String comparatorClass = (String)this.optionsMap.remove("comparator");
        comparatorClass = comparatorClass == null ? (comparatorClass = defaultBytesType) : comparatorClass;
        String dataValidationClass = (String)this.optionsMap.remove("default_validator");
        dataValidationClass = dataValidationClass == null ? (dataValidationClass = defaultBytesType) : dataValidationClass;
        ColumnDefinition key = new CqlColumnDefinitionImpl().setName("key").setValidationClass(keyClass);
        this.partitionKeyList.add(key);
        if (this.compositeSerializer != null) {
            this.processCompositeComparator();
        } else if (comparatorClass.contains("CompositeType")) {
            this.processCompositeComparatorSpec(comparatorClass);
        } else {
            ColumnDefinition column1 = new CqlColumnDefinitionImpl().setName("column1").setValidationClass(comparatorClass);
            this.clusteringKeyList.add(column1);
        }
        ColumnDefinition valueColumn = new CqlColumnDefinitionImpl().setName("value").setValidationClass(dataValidationClass);
        this.regularColumnList.add(valueColumn);
    }

    private void readColDefinitions() {
        Select.Where query = QueryBuilder.select().from("system", "schema_columns").where(QueryBuilder.eq((String)"keyspace_name", (Object)this.keyspaceName)).and(QueryBuilder.eq((String)"columnfamily_name", (Object)this.cfName));
        ResultSet rs = this.session.execute((Statement)query);
        List rows = rs.all();
        if (rows != null && rows.size() > 0) {
            ArrayList<CqlColumnDefinitionImpl> tmpList = new ArrayList<CqlColumnDefinitionImpl>();
            for (Row row : rows) {
                CqlColumnDefinitionImpl cqlColumnDefinitionImpl = new CqlColumnDefinitionImpl(row);
                switch (cqlColumnDefinitionImpl.getColumnType()) {
                    case partition_key: {
                        this.partitionKeyList.add(cqlColumnDefinitionImpl);
                        this.allColumnsDefinitionList.add(cqlColumnDefinitionImpl);
                        break;
                    }
                    case clustering_key: {
                        tmpList.add(cqlColumnDefinitionImpl);
                        this.allColumnsDefinitionList.add(cqlColumnDefinitionImpl);
                        break;
                    }
                    case regular: {
                        this.regularColumnList.add(cqlColumnDefinitionImpl);
                        this.allColumnsDefinitionList.add(cqlColumnDefinitionImpl);
                        break;
                    }
                    case compact_value: {
                        this.regularColumnList.add(cqlColumnDefinitionImpl);
                        this.allColumnsDefinitionList.add(cqlColumnDefinitionImpl);
                    }
                }
            }
            Collections.sort(tmpList);
            this.clusteringKeyList.addAll(tmpList);
            tmpList = null;
            ArrayList<String> allPrimaryKeyColNames = new ArrayList<String>();
            for (ColumnDefinition columnDefinition : this.partitionKeyList) {
                allPrimaryKeyColNames.add(columnDefinition.getName());
            }
            for (ColumnDefinition columnDefinition : this.clusteringKeyList) {
                allPrimaryKeyColNames.add(columnDefinition.getName());
            }
            this.allPkColNames = allPrimaryKeyColNames.toArray(new String[allPrimaryKeyColNames.size()]);
        }
    }

    public CqlColumnFamilyDefinitionImpl alterTable() {
        this.alterTable = true;
        return this;
    }

    public ColumnFamilyDefinition setComment(String comment) {
        this.optionsMap.put("comment", "'" + comment + "'");
        return this;
    }

    public String getComment() {
        return (String)this.optionsMap.get("comment");
    }

    public ColumnFamilyDefinition setKeyspace(String keyspace) {
        this.keyspaceName = keyspace;
        return this;
    }

    public String getKeyspace() {
        return this.keyspaceName;
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableFlushAfterMins(Integer value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public Integer getMemtableFlushAfterMins() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableOperationsInMillions(Double value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public Double getMemtableOperationsInMillions() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableThroughputInMb(Integer value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public Integer getMemtableThroughputInMb() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setMergeShardsChance(Double value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Double getMergeShardsChance() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setMinCompactionThreshold(Integer value) {
        this.optionsMap.put("min_compaction_threshold", value);
        return this;
    }

    public Integer getMinCompactionThreshold() {
        return (Integer)this.optionsMap.get("min_compaction_threshold");
    }

    public ColumnFamilyDefinition setMaxCompactionThreshold(Integer value) {
        this.optionsMap.put("max_compaction_threshold", value);
        return this;
    }

    public Integer getMaxCompactionThreshold() {
        return (Integer)this.optionsMap.get("max_compaction_threshold");
    }

    public ColumnFamilyDefinition setCompactionStrategy(String strategy) {
        this.optionsMap.put("compaction_strategy_class", strategy);
        return this;
    }

    public String getCompactionStrategy() {
        return (String)this.optionsMap.get("compaction_strategy_class");
    }

    public ColumnFamilyDefinition setCompactionStrategyOptions(Map<String, String> options) {
        this.optionsMap.put("compaction_strategy_options", CqlColumnFamilyDefinitionImpl.toJsonString(options));
        return this;
    }

    public Map<String, String> getCompactionStrategyOptions() {
        return CqlColumnFamilyDefinitionImpl.fromJsonString((String)this.optionsMap.get("compaction_strategy_options"));
    }

    public ColumnFamilyDefinition setCompressionOptions(Map<String, String> options) {
        this.optionsMap.put("compression_parameters", CqlColumnFamilyDefinitionImpl.toJsonString(options));
        return this;
    }

    public Map<String, String> getCompressionOptions() {
        return CqlColumnFamilyDefinitionImpl.fromJsonString((String)this.optionsMap.get("compression_parameters"));
    }

    public ColumnFamilyDefinition setBloomFilterFpChance(Double chance) {
        this.optionsMap.put("bloom_filter_fp_chance", chance);
        return this;
    }

    public Double getBloomFilterFpChance() {
        return (Double)this.optionsMap.get("bloom_filter_fp_chance");
    }

    public ColumnFamilyDefinition setCaching(String caching) {
        this.optionsMap.put("caching", caching);
        return this;
    }

    public String getCaching() {
        return (String)this.optionsMap.get("caching");
    }

    public ColumnFamilyDefinition setName(String name) {
        this.cfName = name;
        return this;
    }

    public String getName() {
        return this.cfName;
    }

    public ColumnFamilyDefinition setReadRepairChance(Double value) {
        this.optionsMap.put("read_repair_chance", value);
        return this;
    }

    public Double getReadRepairChance() {
        return (Double)this.optionsMap.get("read_repair_chance");
    }

    public ColumnFamilyDefinition setLocalReadRepairChance(Double value) {
        this.optionsMap.put("local_read_repair_chance", value);
        return this;
    }

    public Double getLocalReadRepairChance() {
        return (Double)this.optionsMap.get("local_read_repair_chance");
    }

    public ColumnFamilyDefinition setReplicateOnWrite(Boolean value) {
        this.optionsMap.put("replicate_on_write", value);
        return this;
    }

    public Boolean getReplicateOnWrite() {
        return (Boolean)this.optionsMap.get("replicate_on_write");
    }

    public ColumnFamilyDefinition setRowCacheProvider(String value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String getRowCacheProvider() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setRowCacheSavePeriodInSeconds(Integer value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Integer getRowCacheSavePeriodInSeconds() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setRowCacheSize(Double size) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Double getRowCacheSize() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setComparatorType(String value) {
        this.optionsMap.put("comparator", value);
        return this;
    }

    public String getComparatorType() {
        return (String)this.optionsMap.get("comparator");
    }

    public ColumnFamilyDefinition setDefaultValidationClass(String value) {
        this.optionsMap.put("default_validator", value);
        return this;
    }

    public String getDefaultValidationClass() {
        return (String)this.optionsMap.get("default_validator");
    }

    public ColumnFamilyDefinition setId(Integer id) {
        this.optionsMap.put("id", id);
        return this;
    }

    public Integer getId() {
        return (Integer)this.optionsMap.get("id");
    }

    public ColumnFamilyDefinition setKeyAlias(ByteBuffer alias) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ByteBuffer getKeyAlias() {
        return null;
    }

    public ColumnFamilyDefinition setKeyCacheSavePeriodInSeconds(Integer value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Integer getKeyCacheSavePeriodInSeconds() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setKeyCacheSize(Double keyCacheSize) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Double getKeyCacheSize() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyDefinition setKeyValidationClass(String keyValidationClass) {
        this.optionsMap.put("key_validator", keyValidationClass);
        return this;
    }

    public String getKeyValidationClass() {
        return (String)this.optionsMap.get("key_validator");
    }

    public ColumnDefinition getPartitionKeyColumnDefinition() {
        return this.partitionKeyList.get(0);
    }

    public List<ColumnDefinition> getRegularColumnDefinitionList() {
        return this.regularColumnList;
    }

    public List<ColumnDefinition> getPartitionKeyColumnDefinitionList() {
        return this.partitionKeyList;
    }

    public List<ColumnDefinition> getClusteringKeyColumnDefinitionList() {
        return this.clusteringKeyList;
    }

    public String[] getAllPkColNames() {
        return this.allPkColNames;
    }

    public ColumnFamilyDefinition addColumnDefinition(ColumnDefinition def) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnDefinition makeColumnDefinition() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void clearColumnDefinitionList() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Collection<String> getFieldNames() {
        return this.optionsMap.keySet();
    }

    public Object getFieldValue(String name) {
        return this.optionsMap.get(name);
    }

    public ColumnFamilyDefinition setFieldValue(String name, Object value) {
        this.optionsMap.put(name, value);
        return this;
    }

    public ColumnFamilyDefinition setGcGraceSeconds(Integer seconds) {
        this.optionsMap.put("gc_grace_seconds", seconds);
        return this;
    }

    public Integer getGcGraceSeconds() {
        return (Integer)this.optionsMap.get("gc_grace_seconds");
    }

    public Collection<FieldMetadata> getFieldsMetadata() {
        ArrayList<FieldMetadata> list = new ArrayList<FieldMetadata>();
        for (String key : this.optionsMap.keySet()) {
            Object value = this.optionsMap.get(key);
            Class<?> clazz = value.getClass();
            String name = key.toUpperCase();
            String type = clazz.getSimpleName().toUpperCase();
            boolean isContainer = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            list.add(new FieldMetadata(name, type, isContainer));
        }
        return list;
    }

    public void setFields(Map<String, Object> options) {
        this.optionsMap.putAll(options);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        for (String key : this.optionsMap.keySet()) {
            if (this.optionsMap.get(key) == null) continue;
            props.put(key, this.optionsMap.get(key));
        }
        return props;
    }

    public void setProperties(Properties additionalProperties) throws Exception {
        Map<String, Object> props = CqlColumnFamilyDefinitionImpl.propertiesToMap(additionalProperties);
        this.optionsMap.putAll(props);
    }

    public OperationResult<SchemaChangeResult> execute() {
        this.createColumnDefinitions();
        String query = this.alterTable ? this.getUpdateQuery() : this.getCreateQuery();
        ResultSet rs = this.session.execute(query);
        return new CqlOperationResultImpl<Object>(rs, null);
    }

    private String getCreateQuery() {
        boolean compositePrimaryKey;
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.keyspaceName).append(".").append(this.cfName);
        sb.append(" ( ");
        boolean bl = compositePrimaryKey = this.clusteringKeyList.size() > 0;
        if (!compositePrimaryKey) {
            this.appendColDefinition(sb, this.partitionKeyList.iterator());
            sb.append(" PRIMARY KEY, ");
            this.appendColDefinition(sb, this.regularColumnList.iterator());
        } else {
            this.appendColDefinition(sb, this.partitionKeyList.iterator());
            sb.append(" ,");
            this.appendColDefinition(sb, this.clusteringKeyList.iterator());
            sb.append(" ,");
            this.appendColDefinition(sb, this.regularColumnList.iterator());
            sb.append(", PRIMARY KEY (");
            this.appendPrimaryKeyDefinition(sb, this.partitionKeyList.iterator(), this.clusteringKeyList.iterator());
            sb.append(") ");
        }
        sb.append(")");
        if (this.optionsMap.size() > 0) {
            sb.append(" WITH ");
            Iterator<String> propIter = this.optionsMap.keySet().iterator();
            while (propIter.hasNext()) {
                String pKey = propIter.next();
                Object pValue = this.optionsMap.get(pKey);
                if (pValue == null) continue;
                if (pValue instanceof String) {
                    sb.append(pKey).append(" = '").append(pValue).append("'");
                } else {
                    sb.append(pKey).append(" = ").append(pValue);
                }
                if (!propIter.hasNext()) continue;
                sb.append(" AND ");
            }
        }
        String query = sb.toString();
        return query;
    }

    private String getUpdateQuery() {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        sb.append(this.keyspaceName).append(".").append(this.cfName);
        sb.append(" WITH ");
        Iterator<String> propIter = this.optionsMap.keySet().iterator();
        while (propIter.hasNext()) {
            String pKey = propIter.next();
            Object pValue = this.optionsMap.get(pKey);
            sb.append(pKey).append(" = ").append(pValue);
            if (!propIter.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private void appendColDefinition(StringBuilder sb, Iterator<ColumnDefinition> iter) {
        while (iter.hasNext()) {
            CqlColumnDefinitionImpl colDef = (CqlColumnDefinitionImpl)iter.next();
            sb.append(colDef.getName()).append(" ").append(colDef.getCqlType());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
    }

    private void appendPrimaryKeyDefinition(StringBuilder sb, Iterator<ColumnDefinition> iter1, Iterator<ColumnDefinition> iter2) {
        CqlColumnDefinitionImpl colDef;
        while (iter1.hasNext()) {
            colDef = (CqlColumnDefinitionImpl)iter1.next();
            sb.append(colDef.getName());
            if (!iter1.hasNext()) continue;
            sb.append(", ");
        }
        if (iter2.hasNext()) {
            sb.append(", ");
            while (iter2.hasNext()) {
                colDef = (CqlColumnDefinitionImpl)iter2.next();
                sb.append(colDef.getName());
                if (!iter2.hasNext()) continue;
                sb.append(", ");
            }
        }
    }

    private static Map<String, Object> propertiesToMap(Properties props) {
        TreeMap root = Maps.newTreeMap();
        if (props == null) {
            return root;
        }
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String[] parts = StringUtils.split((String)((String)prop.getKey()), (String)".");
            Map node = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!node.containsKey(parts[i])) {
                    node.put(parts[i], new LinkedHashMap());
                }
                node = (Map)node.get(parts[i]);
            }
            node.put(parts[parts.length - 1], (String)prop.getValue());
        }
        return root;
    }

    private static String toJsonString(Map<String, String> options) {
        if (options == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : options.keySet()) {
            try {
                json.put(key, (Object)options.get(key));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return json.toString();
    }

    private static Map<String, String> fromJsonString(String jsonString) {
        if (jsonString == null) {
            return new HashMap<String, String>();
        }
        try {
            JSONObject json = new JSONObject(jsonString);
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = json.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = json.getString(key).toString();
                map.put(key, value);
            }
            return map;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ColumnDefinition> getColumnDefinitionList() {
        return this.allColumnsDefinitionList;
    }

    public CFMutationQueryGen getMutationQueryGenerator() {
        return this.mutationQueryGen;
    }

    public CFRowQueryGen getRowQueryGenerator() {
        return this.rowQueryGen;
    }

    public void printOptionsMap() {
        for (String key : this.optionsMap.keySet()) {
            System.out.println(key + " " + this.optionsMap.get(key));
        }
    }
}

