/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CFRowSliceQueryGen;
import com.netflix.astyanax.cql.reads.CqlRowSliceQueryImpl;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.reads.model.CqlRowSlice;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class CFRowRangeQueryGen
extends CFRowSliceQueryGen {
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectAllColumnsForRowRange;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnSetForRowRange;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnRangeForRowRange;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectCompositeColumnRangeForRowRange;

    public CFRowRangeQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        super(session, keyspaceName, cfDefinition);
        this.SelectAllColumnsForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        Select select = CFRowRangeQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        return CFRowRangeQueryGen.this.addWhereClauseForRowRange(CFRowRangeQueryGen.this.partitionKeyCol, select, rowSliceQuery.getRowSlice().getRange());
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                ArrayList values = new ArrayList();
                CFRowRangeQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
                return pStatement.bind(values.toArray(new Object[values.size()]));
            }
        };
        this.SelectColumnSetForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        CqlRowSlice.RowRange range = rowSliceQuery.getRowSlice().getRange();
                        Collection cols = rowSliceQuery.getColumnSlice().getColumns();
                        Object[] columns = cols.toArray(new Object[cols.size()]);
                        Select select = CFRowRangeQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        if (columns != null && columns.length > 0) {
                            select.allowFiltering();
                        }
                        Select.Where where = CFRowRangeQueryGen.this.addWhereClauseForRowRange(CFRowRangeQueryGen.this.partitionKeyCol, select, range);
                        where.and(QueryBuilder.in((String)((ColumnDefinition)CFRowRangeQueryGen.this.clusteringKeyCols.get(0)).getName(), (Object[])columns));
                        return where;
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                ArrayList values = new ArrayList();
                CFRowRangeQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
                values.addAll(rowSliceQuery.getColumnSlice().getColumns());
                return pStatement.bind(values.toArray());
            }
        };
        this.SelectColumnRangeForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        Select select = CFRowRangeQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        CqlColumnSlice columnSlice = rowSliceQuery.getColumnSlice();
                        if (columnSlice != null && columnSlice.isRangeQuery()) {
                            select.allowFiltering();
                        }
                        Select.Where where = CFRowRangeQueryGen.this.addWhereClauseForRowRange(CFRowRangeQueryGen.this.partitionKeyCol, select, rowSliceQuery.getRowSlice().getRange());
                        where = CFRowRangeQueryGen.this.addWhereClauseForColumnRange(where, columnSlice);
                        return where;
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                ArrayList<Object> values = new ArrayList<Object>();
                CFRowRangeQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
                CFRowRangeQueryGen.this.bindWhereClauseForColumnRange(values, rowSliceQuery.getColumnSlice());
                return pStatement.bind(values.toArray());
            }
        };
        this.SelectCompositeColumnRangeForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        Select select = CFRowRangeQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        CompositeRangeBuilder.CompositeByteBufferRange compositeRange = rowSliceQuery.getCompositeRange();
                        if (compositeRange != null) {
                            select.allowFiltering();
                        }
                        Select.Where where = CFRowRangeQueryGen.this.addWhereClauseForRowRange(CFRowRangeQueryGen.this.partitionKeyCol, select, rowSliceQuery.getRowSlice().getRange());
                        where = CFRowRangeQueryGen.this.addWhereClauseForCompositeColumnRange(where, compositeRange);
                        return where;
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                ArrayList<Object> values = new ArrayList<Object>();
                CFRowRangeQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
                CFRowRangeQueryGen.this.bindWhereClauseForCompositeColumnRange(values, rowSliceQuery.getCompositeRange());
                return pStatement.bind(values.toArray());
            }
        };
    }

    private Select.Where addWhereClauseForRowRange(String keyAlias, Select select, CqlRowSlice.RowRange<?> rowRange) {
        Select.Where where = null;
        boolean keyIsPresent = false;
        boolean tokenIsPresent = false;
        if (rowRange.getStartKey() != null || rowRange.getEndKey() != null) {
            keyIsPresent = true;
        }
        if (rowRange.getStartToken() != null || rowRange.getEndToken() != null) {
            tokenIsPresent = true;
        }
        if (keyIsPresent && tokenIsPresent) {
            throw new RuntimeException("Cannot provide both token and keys for range query");
        }
        if (keyIsPresent) {
            if (rowRange.getStartKey() != null && rowRange.getEndKey() != null) {
                where = select.where(QueryBuilder.gte((String)keyAlias, (Object)"?")).and(QueryBuilder.lte((String)keyAlias, (Object)"?"));
            } else if (rowRange.getStartKey() != null) {
                where = select.where(QueryBuilder.gte((String)keyAlias, (Object)"?"));
            } else if (rowRange.getEndKey() != null) {
                where = select.where(QueryBuilder.lte((String)keyAlias, (Object)"?"));
            }
        } else if (tokenIsPresent) {
            String tokenOfKey = "token(" + keyAlias + ")";
            if (rowRange.getStartToken() != null && rowRange.getEndToken() != null) {
                where = select.where(QueryBuilder.gte((String)tokenOfKey, (Object)"?")).and(QueryBuilder.lte((String)tokenOfKey, (Object)"?"));
            } else if (rowRange.getStartToken() != null) {
                where = select.where(QueryBuilder.gte((String)tokenOfKey, (Object)"?"));
            } else if (rowRange.getEndToken() != null) {
                where = select.where(QueryBuilder.lte((String)tokenOfKey, (Object)"?"));
            }
        } else {
            where = select.where();
        }
        if (rowRange.getCount() > 0) {
            // empty if block
        }
        return where;
    }

    private void bindWhereClauseForRowRange(List<Object> values, CqlRowSlice.RowRange<?> rowRange) {
        boolean keyIsPresent = false;
        boolean tokenIsPresent = false;
        if (rowRange.getStartKey() != null || rowRange.getEndKey() != null) {
            keyIsPresent = true;
        }
        if (rowRange.getStartToken() != null || rowRange.getEndToken() != null) {
            tokenIsPresent = true;
        }
        if (keyIsPresent && tokenIsPresent) {
            throw new RuntimeException("Cannot provide both token and keys for range query");
        }
        if (keyIsPresent) {
            if (rowRange.getStartKey() != null) {
                values.add(rowRange.getStartKey());
            }
            if (rowRange.getEndKey() != null) {
                values.add(rowRange.getEndKey());
            }
        } else if (tokenIsPresent) {
            BigInteger startTokenB = rowRange.getStartToken() != null ? new BigInteger(rowRange.getStartToken()) : null;
            BigInteger endTokenB = rowRange.getEndToken() != null ? new BigInteger(rowRange.getEndToken()) : null;
            Long startToken = startTokenB.longValue();
            Long endToken = endTokenB.longValue();
            if (startToken != null && endToken != null) {
                if (startToken != null) {
                    values.add(startToken);
                }
                if (endToken != null) {
                    values.add(endToken);
                }
            }
            if (rowRange.getCount() > 0) {
                // empty if block
            }
            return;
        }
    }

    public BoundStatement getQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        switch (rowSliceQuery.getColQueryType()) {
            case AllColumns: {
                return this.SelectAllColumnsForRowRange.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnSet: {
                return this.SelectColumnSetForRowRange.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnRange: {
                if (this.isCompositeColumn) {
                    return this.SelectCompositeColumnRangeForRowRange.getBoundStatement(rowSliceQuery, useCaching);
                }
                return this.SelectColumnRangeForRowRange.getBoundStatement(rowSliceQuery, useCaching);
            }
        }
        throw new RuntimeException("RowSliceQuery with row range use case not supported.");
    }
}

