/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class DisjunctionScorer
extends Scorer {
    private final boolean needsScores;
    private final DisiPriorityQueue<Scorer> subScorers;
    private final long cost;
    private DisiWrapper<Scorer> topScorers;

    protected DisjunctionScorer(Weight weight, List<Scorer> subScorers, boolean needsScores) {
        super(weight);
        if (subScorers.size() <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.subScorers = new DisiPriorityQueue(subScorers.size());
        long cost = 0L;
        for (Scorer scorer : subScorers) {
            DisiWrapper<Scorer> w = new DisiWrapper<Scorer>(scorer);
            cost += w.cost;
            this.subScorers.add(w);
        }
        this.cost = cost;
        this.needsScores = needsScores;
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        float sumMatchCost = 0.0f;
        long sumApproxCost = 0L;
        for (DisiWrapper<Scorer> disiWrapper : this.subScorers) {
            if (disiWrapper.twoPhaseView == null) continue;
            long costWeight = disiWrapper.cost <= 1L ? 1L : disiWrapper.cost;
            sumMatchCost += disiWrapper.twoPhaseView.matchCost() * (float)costWeight;
            sumApproxCost += costWeight;
        }
        if (sumApproxCost == 0L) {
            return null;
        }
        final float matchCost = sumMatchCost / (float)sumApproxCost;
        return new TwoPhaseIterator(new DisjunctionDISIApproximation<Scorer>(this.subScorers)){

            @Override
            public boolean matches() throws IOException {
                DisiWrapper topScorers = DisjunctionScorer.this.subScorers.topList();
                while (topScorers.twoPhaseView != null && !topScorers.twoPhaseView.matches()) {
                    topScorers = topScorers.next;
                    if (topScorers != null) continue;
                    return false;
                }
                if (DisjunctionScorer.this.needsScores) {
                    DisiWrapper previous = topScorers;
                    DisiWrapper w = topScorers.next;
                    while (w != null) {
                        if (w.twoPhaseView != null && !w.twoPhaseView.matches()) {
                            previous.next = w.next;
                        } else {
                            previous = w;
                        }
                        w = w.next;
                    }
                } else {
                    topScorers.next = null;
                }
                DisjunctionScorer.this.topScorers = topScorers;
                return true;
            }

            @Override
            public float matchCost() {
                return matchCost;
            }
        };
    }

    @Override
    public final long cost() {
        return this.cost;
    }

    @Override
    public final int docID() {
        return this.subScorers.top().doc;
    }

    @Override
    public final int nextDoc() throws IOException {
        this.topScorers = null;
        DisiWrapper<Scorer> top = this.subScorers.top();
        int doc = top.doc;
        do {
            top.doc = ((Scorer)top.iterator).nextDoc();
            top = this.subScorers.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    @Override
    public final int advance(int target) throws IOException {
        this.topScorers = null;
        DisiWrapper<Scorer> top = this.subScorers.top();
        do {
            top.doc = ((Scorer)top.iterator).advance(target);
            top = this.subScorers.updateTop();
        } while (top.doc < target);
        return top.doc;
    }

    @Override
    public final int freq() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        int freq = 1;
        DisiWrapper w = this.topScorers.next;
        while (w != null) {
            ++freq;
            w = w.next;
        }
        return freq;
    }

    @Override
    public final float score() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        return this.score(this.topScorers);
    }

    protected abstract float score(DisiWrapper<Scorer> var1) throws IOException;

    @Override
    public final Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (DisiWrapper<Scorer> disiWrapper : this.subScorers) {
            children.add(new Scorer.ChildScorer((Scorer)disiWrapper.iterator, "SHOULD"));
        }
        return children;
    }
}

