/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableUtil {
    public static Object clone(Object object) {
        return SerializableUtil.deserialize(SerializableUtil.serialize(object));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes) {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new UnsyncByteArrayInputStream(bytes));
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                throw new RuntimeException(cnfe);
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(objectInputStream);
                throw throwable;
            }
        }
        StreamUtil.cleanUp(objectInputStream);
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes, ClassLoader classLoader) {
        Object object;
        ClassLoaderObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ClassLoaderObjectInputStream(new UnsyncByteArrayInputStream(bytes), classLoader);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                throw new RuntimeException(cnfe);
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(objectInputStream);
                throw throwable;
            }
        }
        StreamUtil.cleanUp(objectInputStream);
        return object;
    }

    public static byte[] serialize(Object object) {
        ObjectOutputStream objectOutputStream = null;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try {
            try {
                objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);
                objectOutputStream.writeObject(object);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(objectOutputStream);
            throw throwable;
        }
        StreamUtil.cleanUp(objectOutputStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

