/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import java.util.Map;

public abstract class BaseMultiDestinationProxyBean {
    private MessageSender _messageSender;
    private SynchronousMessageSender _synchronousMessageSender;

    public abstract String getDestinationName(ProxyRequest var1);

    public void send(ProxyRequest proxyRequest) {
        this._messageSender.send(this.getDestinationName(proxyRequest), this.buildMessage(proxyRequest));
    }

    public void setMessageSender(MessageSender messageSender) {
        this._messageSender = messageSender;
    }

    public void setSynchronousMessageSender(SynchronousMessageSender synchronousMessageSender) {
        this._synchronousMessageSender = synchronousMessageSender;
    }

    public Object synchronousSend(ProxyRequest proxyRequest) throws Exception {
        ProxyResponse proxyResponse = (ProxyResponse)this._synchronousMessageSender.send(this.getDestinationName(proxyRequest), this.buildMessage(proxyRequest));
        if (proxyResponse == null) {
            return proxyRequest.execute(this);
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }

    protected Message buildMessage(ProxyRequest proxyRequest) {
        Message message = new Message();
        message.setPayload(proxyRequest);
        Map<String, Object> values = MessageValuesThreadLocal.getValues();
        if (!values.isEmpty()) {
            for (String key : values.keySet()) {
                message.put(key, values.get(key));
            }
        }
        return message;
    }
}

