/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.Server;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.ReadyMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class RegisterMessage
extends Message.Request {
    public static final Message.Codec<RegisterMessage> codec = new Message.Codec<RegisterMessage>(){

        @Override
        public RegisterMessage decode(ChannelBuffer body) {
            int length = body.readUnsignedShort();
            ArrayList<Event.Type> eventTypes = new ArrayList<Event.Type>(length);
            for (int i = 0; i < length; ++i) {
                eventTypes.add(CBUtil.readEnumValue(Event.Type.class, body));
            }
            return new RegisterMessage(eventTypes);
        }

        @Override
        public ChannelBuffer encode(RegisterMessage msg) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeShort(msg.eventTypes.size());
            for (Event.Type type : msg.eventTypes) {
                cb.writeBytes(CBUtil.enumValueToCB(type));
            }
            return cb;
        }
    };
    public final List<Event.Type> eventTypes;

    public RegisterMessage(List<Event.Type> eventTypes) {
        super(Message.Type.REGISTER);
        this.eventTypes = eventTypes;
    }

    @Override
    public Message.Response execute(QueryState state) {
        assert (this.connection instanceof ServerConnection);
        Connection.Tracker tracker = ((ServerConnection)this.connection).getTracker();
        assert (tracker instanceof Server.ConnectionTracker);
        for (Event.Type type : this.eventTypes) {
            ((Server.ConnectionTracker)tracker).register(type, this.connection().channel());
        }
        return new ReadyMessage();
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    public String toString() {
        return "REGISTER " + this.eventTypes;
    }
}

