/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.scheduler;

import java.lang.management.ManagementFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.scheduler.WeightedQueueMBean;

class WeightedQueue
implements WeightedQueueMBean {
    private final LatencyMetrics metric;
    public final String key;
    public final int weight;
    private final SynchronousQueue<Entry> queue;

    public WeightedQueue(String key, int weight) {
        this.key = key;
        this.weight = weight;
        this.queue = new SynchronousQueue(true);
        this.metric = new LatencyMetrics("scheduler", "WeightedQueue", key);
    }

    public void register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.scheduler:type=WeightedQueue,queue=" + this.key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void put(Thread t, long timeoutMS) throws InterruptedException, TimeoutException {
        if (!this.queue.offer(new Entry(t), timeoutMS, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Failed to acquire request scheduler slot for '" + this.key + "'");
        }
    }

    public Thread poll() {
        Entry e = this.queue.poll();
        if (e == null) {
            return null;
        }
        this.metric.addNano(System.nanoTime() - e.creationTime);
        return e.thread;
    }

    public String toString() {
        return "RoundRobinScheduler.WeightedQueue(key=" + this.key + " weight=" + this.weight + ")";
    }

    @Override
    public long getOperations() {
        return this.metric.latency.count();
    }

    @Override
    public long getTotalLatencyMicros() {
        return this.metric.totalLatency.count();
    }

    @Override
    public double getRecentLatencyMicros() {
        return this.metric.getRecentLatency();
    }

    @Override
    public long[] getTotalLatencyHistogramMicros() {
        return this.metric.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentLatencyHistogramMicros() {
        return this.metric.recentLatencyHistogram.getBuckets(true);
    }

    private static final class Entry {
        public final long creationTime = System.nanoTime();
        public final Thread thread;

        public Entry(Thread thread) {
            this.thread = thread;
        }
    }
}

