/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class Column
implements IColumn {
    private static final ColumnSerializer serializer = new ColumnSerializer();
    private static final OnDiskAtom.Serializer onDiskSerializer = new OnDiskAtom.Serializer(serializer);
    protected final ByteBuffer name;
    protected final ByteBuffer value;
    protected final long timestamp;

    public static ColumnSerializer serializer() {
        return serializer;
    }

    public static OnDiskAtom.Serializer onDiskSerializer() {
        return onDiskSerializer;
    }

    Column(ByteBuffer name) {
        this(name, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    public Column(ByteBuffer name, ByteBuffer value) {
        this(name, value, 0L);
    }

    public Column(ByteBuffer name, ByteBuffer value, long timestamp) {
        assert (name != null);
        assert (value != null);
        assert (name.remaining() <= 65535);
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
    }

    @Override
    public ByteBuffer name() {
        return this.name;
    }

    @Override
    public Column getSubColumn(ByteBuffer columnName) {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    @Override
    public Collection<IColumn> getSubColumns() {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long minTimestamp() {
        return this.timestamp;
    }

    @Override
    public long maxTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isMarkedForDelete() {
        return (int)(System.currentTimeMillis() / 1000L) >= this.getLocalDeletionTime();
    }

    @Override
    public long getMarkedForDeleteAt() {
        throw new IllegalStateException("column is not marked for delete");
    }

    @Override
    public long mostRecentLiveChangeAt() {
        return this.timestamp;
    }

    @Override
    public long mostRecentNonGCableChangeAt(int gcbefore) {
        return this.timestamp;
    }

    @Override
    public int dataSize() {
        return this.name().remaining() + this.value.remaining() + TypeSizes.NATIVE.sizeof(this.timestamp);
    }

    @Override
    public int serializedSize(TypeSizes typeSizes) {
        int nameSize = this.name.remaining();
        int valueSize = this.value.remaining();
        return typeSizes.sizeof((short)nameSize) + nameSize + 1 + typeSizes.sizeof(this.timestamp) + typeSizes.sizeof(valueSize) + valueSize;
    }

    @Override
    public long serializedSizeForSSTable() {
        return this.serializedSize(TypeSizes.NATIVE);
    }

    @Override
    public int serializationFlags() {
        return 0;
    }

    @Override
    public void addColumn(IColumn column) {
        this.addColumn(null, null);
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        throw new UnsupportedOperationException("This operation is not supported for simple columns.");
    }

    @Override
    public IColumn diff(IColumn column) {
        if (this.timestamp() < column.timestamp()) {
            return column;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public IColumn reconcile(IColumn column) {
        return this.reconcile(column, HeapAllocator.instance);
    }

    @Override
    public IColumn reconcile(IColumn column, Allocator allocator) {
        if (this.isMarkedForDelete()) {
            return this.timestamp() < column.timestamp() ? column : this;
        }
        if (column.isMarkedForDelete()) {
            return this.timestamp() > column.timestamp() ? this : column;
        }
        if (this.timestamp() == column.timestamp()) {
            return this.value().compareTo(column.value()) < 0 ? column : this;
        }
        return this.timestamp() < column.timestamp() ? column : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        if (this.timestamp != column.timestamp) {
            return false;
        }
        if (!this.name.equals(column.name)) {
            return false;
        }
        return this.value.equals(column.value);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return this.localCopy(cfs, HeapAllocator.instance);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        return new Column(cfs.internOrCopy(this.name, allocator), allocator.clone(this.value), this.timestamp);
    }

    @Override
    public String getString(AbstractType<?> comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(comparator.getString(this.name));
        sb.append(":");
        sb.append(this.isMarkedForDelete());
        sb.append(":");
        sb.append(this.value.remaining());
        sb.append("@");
        sb.append(this.timestamp());
        return sb.toString();
    }

    @Override
    public boolean isLive() {
        return !this.isMarkedForDelete();
    }

    protected void validateName(CFMetaData metadata) throws MarshalException {
        AbstractType<?> nameValidator = metadata.cfType == ColumnFamilyType.Super ? metadata.subcolumnComparator : metadata.comparator;
        nameValidator.validate(this.name());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        CFDefinition cfdef = metadata.getCfDef();
        ByteBuffer internalName = cfdef.isComposite && !cfdef.isCompact ? ((CompositeType)metadata.comparator).extractLastComponent(this.name) : this.name;
        AbstractType<?> valueValidator = metadata.getValueValidator(internalName);
        if (valueValidator != null) {
            valueValidator.validate(this.value());
        }
    }

    @Override
    public boolean hasIrrelevantData(int gcBefore) {
        return this.getLocalDeletionTime() < gcBefore;
    }

    public static Column create(String value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), UTF8Type.instance.decompose(value), timestamp);
    }

    public static Column create(int value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), Int32Type.instance.decompose(value), timestamp);
    }

    public static Column create(boolean value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), BooleanType.instance.decompose(value), timestamp);
    }

    public static Column create(double value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), DoubleType.instance.decompose(value), timestamp);
    }

    public static Column create(ByteBuffer value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), value, timestamp);
    }

    public static Column create(InetAddress value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), InetAddressType.instance.decompose(value), timestamp);
    }

    static ByteBuffer decomposeName(String ... names) {
        assert (names.length > 0);
        if (names.length == 1) {
            return UTF8Type.instance.decompose(names[0]);
        }
        ArrayList types = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            types.add(UTF8Type.instance);
        }
        CompositeType.Builder builder = new CompositeType.Builder(CompositeType.getInstance(types));
        for (String name : names) {
            builder.add(UTF8Type.instance.decompose(name));
        }
        return builder.build();
    }
}

