/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.util.Utils;

final class LZ4HCJNICompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4HCJNICompressor();

    LZ4HCJNICompressor() {
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        if (maxDestLen < this.maxCompressedLength(srcLen)) {
            throw new IllegalArgumentException("This compressor does not support output buffers whose size is < maxCompressedLength(srcLen)");
        }
        int result = LZ4JNI.LZ4_compressHC(src, srcOff, srcLen, dest, destOff);
        if (result <= 0) {
            throw new LZ4Exception();
        }
        return result;
    }
}

