/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.Hashtag;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Invite;
import org.gcube.social_networking.socialnetworking.model.shared.InviteStatus;
import org.gcube.social_networking.socialnetworking.model.shared.Post;
import org.gcube.social_networking.socialnetworking.model.shared.Vre;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="vres")
@ResourceGroup(value="Vres APIs")
@ResourceLabel(value="Vres APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Vres
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Vres.class);

    private Response ErrorHandler(Exception e, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " vre {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAllVreIds() {
        try {
            logger.info("Getting all VRE IDs");
            ArrayList<String> ids = new ArrayList<String>();
            List vres = (List)((ResponseBean)super.readAll(ResourceNames.VRE).readEntity((GenericType)new /* Unavailable Anonymous Inner Class!! */)).getResult();
            for (Vre vre : vres) {
                ids.add(vre.getId());
            }
            Response.Status status = Response.Status.OK;
            ResponseBean responseBean = new ResponseBean();
            responseBean.setMessage("vre ids fetched Successfully");
            responseBean.setSuccess(true);
            responseBean.setResult(ids);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch ids of", "");
        }
    }

    @GET
    @Path(value="/{id}/posts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getRecentPostsByVre(@NotNull @PathParam(value="id") String id, @QueryParam(value="limit") Integer limit) {
        try {
            logger.info("Getting most recent {} posts of VRE {} ", (Object)limit, (Object)id);
            if (limit != null) {
                return super.readChildOfWithParameter(id, "recent_limit", String.valueOf(limit), ResourceNames.VRE, ResourceNames.POST);
            }
            return super.readChildOf(id, ResourceNames.VRE, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch recent posts of", id);
        }
    }

    @POST
    @Path(value="/{id}/posts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response savePostToVRETimeline(@NotNull @PathParam(value="id") String id, @NotNull Post post) {
        try {
            logger.info("saving post {} to VRE {} ", (Object)post.getKey(), (Object)id);
            return super.createChildOf(id, (IdResource)post, ResourceNames.VRE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "save post to", id);
        }
    }

    @GET
    @Path(value="/{id}/hashtags")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getVREHashtagsWithOccurrenceFilteredByTime(@NotNull @PathParam(value="id") String id, @QueryParam(value="time") Long timestamp) {
        try {
            logger.info("getting hashtags of VRE {} starting {} ", (Object)id, (Object)timestamp);
            if (timestamp == null) {
                return super.readChildOf(id, ResourceNames.VRE, ResourceNames.HASHTAG);
            }
            return super.readChildOfWithParameter(id, "time", String.valueOf(timestamp), ResourceNames.VRE, ResourceNames.HASHTAG);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "get time_filtered hashtags of", id);
        }
    }

    @GET
    @Path(value="/{id}/hashtags/{hashtag}/posts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getVREPostsByHashtag(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="hashtag") String hashtag) {
        try {
            logger.info("getting posts containing hashtags in VRE {}", (Object)id);
            return super.readChildOfWithParameter(id, "hashtag", hashtag, ResourceNames.VRE, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "get posts containing hashtag in", id);
        }
    }

    @GET
    @Path(value="/{id}/invites/")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getInvitedEmailsByVRE(@NotNull @PathParam(value="id") String id, InviteStatus ... status) {
        try {
            logger.info("getting invites in VRE {}", (Object)id);
            return super.readChildOfWithParameter(id, "status", Arrays.toString(status), ResourceNames.VRE, ResourceNames.INVITE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "get invites in", id);
        }
    }

    @GET
    @Path(value="/{id}/invites/{email}")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response isExistingInvite(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="email") String email) {
        try {
            logger.info("checking if invite {} exists in VRE {}", (Object)email, (Object)id);
            return super.readChildOfWithParameter(id, "email", email, ResourceNames.VRE, ResourceNames.INVITE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "check invite in", id);
        }
    }

    @PUT
    @Path(value="/{id}/invites/{email}")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response setInviteStatus(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="email") String email, @NotNull InviteStatus inviteStatus) {
        try {
            logger.info("setting invite {} status in VRE {}", (Object)email, (Object)id);
            Invite invite = new Invite();
            invite.setStatus(inviteStatus);
            return super.updateChildOfWithParameter(id, "email", email, (IdResource)invite, ResourceNames.VRE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "set invite status in", id);
        }
    }

    @POST
    @Path(value="/{id}/posts/{postid}/hashtags")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response saveHashTags(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="postid") String postid, @NotNull List<Hashtag> hashtags) {
        try {
            logger.info("saving post hashtags to VRE {} ", (Object)id);
            return super.BatchCreateChildOfWithParameter(id, ResourceNames.POST, postid, new ArrayList<Hashtag>(hashtags), ResourceNames.VRE, ResourceNames.HASHTAG);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "save post hashtags to", id);
        }
    }

    @DELETE
    @Path(value="/{id}/posts/{postid}/hashtags")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response deleteHashTags(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="postid") String postid, @NotNull List<Hashtag> hashtags) {
        try {
            logger.info("deleting post hashtags from VRE {} ", (Object)id);
            return super.BatchDeleteChildOfWithParameter(id, ResourceNames.POST, postid, new ArrayList<Hashtag>(hashtags), ResourceNames.VRE, ResourceNames.HASHTAG);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete post hashtags from", id);
        }
    }

    @POST
    @Path(value="/{id}/comments/{commentid}/hashtags")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response saveHashTagsComment(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="commentid") String commentid, @NotNull List<Hashtag> hashtags) {
        try {
            logger.info("saving comment hashtags to VRE {} ", (Object)id);
            return super.BatchCreateChildOfWithParameter(id, ResourceNames.COMMENT, commentid, new ArrayList<Hashtag>(hashtags), ResourceNames.VRE, ResourceNames.HASHTAG);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "save comment hashtags to", id);
        }
    }

    @DELETE
    @Path(value="/{id}/comments/{commentid}/hashtags")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response deleteHashTagsComment(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="commentid") String commentid, @NotNull List<Hashtag> hashtags) {
        try {
            logger.info("deleting comment hashtags from VRE {} ", (Object)id);
            return super.BatchDeleteChildOfWithParameter(id, ResourceNames.COMMENT, commentid, new ArrayList<Hashtag>(hashtags), ResourceNames.VRE, ResourceNames.HASHTAG);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete comment hashtags from", id);
        }
    }
}

