/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Like;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="likes")
@ResourceGroup(value="Likes APIs")
@ResourceLabel(value="Likes APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Likes
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Likes.class);

    private Response ErrorHandler(Exception e, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " like {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createLike(Like like) {
        try {
            logger.info("Creating like with id {}.", (Object)like.getKey());
            return super.create((IdResource)like);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create", like.getKey());
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readLike(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading like with id {}.", (Object)id);
            return super.read(id, ResourceNames.LIKE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch", id);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteLike(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Deleting like with id {}.", (Object)id);
            return super.delete(id, ResourceNames.LIKE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete", id);
        }
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateLike(@NotNull @PathParam(value="id") String id, @NotNull Like like) {
        try {
            logger.info("Updating like with id {}", (Object)id);
            return super.update(id, (IdResource)like);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "update", id);
        }
    }
}

