package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;


@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("FOLDER_SHARE")
public class WorkspaceNotificationSharedFolder extends WorkspaceNotification {

	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("folderItem")
	@NotNull(message="folderItem cannot be missing")
	private WorkspaceFolderBean folder;
	
	
	public WorkspaceNotificationSharedFolder() {
		super(WorkspaceNotificationType.FOLDER_SHARE);
	}

	public WorkspaceNotificationSharedFolder(String userIdToNotify, WorkspaceFolderBean folder) {
		super(WorkspaceNotificationType.FOLDER_SHARE);
		this.userIdToNotify = userIdToNotify;
		this.folder = folder;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public WorkspaceFolderBean getFolder() {
		return folder;
	}

	public void setFolder(WorkspaceFolderBean folder) {
		this.folder = folder;
	}

	@Override
	public String toString() {
		return "WorkspaceNotificationSharedFolder [userIdToNotify=" + userIdToNotify + ", folder=" + folder + "]";
	}	
}
